/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.taskrouter.Activity;
import com.twilio.sdk.resource.instance.taskrouter.Event;
import com.twilio.sdk.resource.instance.taskrouter.StatisticsQueryBuilder;
import com.twilio.sdk.resource.instance.taskrouter.Task;
import com.twilio.sdk.resource.instance.taskrouter.TaskQueue;
import com.twilio.sdk.resource.instance.taskrouter.Worker;
import com.twilio.sdk.resource.instance.taskrouter.Workflow;
import com.twilio.sdk.resource.instance.taskrouter.WorkspaceStatistics;
import com.twilio.sdk.resource.list.taskrouter.ActivityList;
import com.twilio.sdk.resource.list.taskrouter.EventList;
import com.twilio.sdk.resource.list.taskrouter.TaskList;
import com.twilio.sdk.resource.list.taskrouter.TaskQueueList;
import com.twilio.sdk.resource.list.taskrouter.WorkerList;
import com.twilio.sdk.resource.list.taskrouter.WorkflowList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;

public class Workspace
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    public Workspace(TwilioTaskRouterClient client) {
        super(client);
    }

    public Workspace(TwilioTaskRouterClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Workspace(TwilioTaskRouterClient client, String sid) {
        super(client);
        if (StringUtils.isBlank((CharSequence)sid)) {
            throw new IllegalArgumentException("The Sid for a Workspace cannot be null");
        }
        this.setProperty("sid", sid);
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public ActivityList getActivities() {
        ActivityList activities = new ActivityList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return activities;
    }

    public ActivityList getActivities(Map<String, String> filters) {
        ActivityList activities = new ActivityList((TwilioTaskRouterClient)this.getClient(), this.getSid(), filters);
        return activities;
    }

    public Activity getActivity(String activitySid) {
        Activity activity = new Activity((TwilioTaskRouterClient)this.getClient(), this.getSid(), activitySid);
        return activity;
    }

    public Activity createActivity(Map<String, String> params) throws TwilioRestException {
        ActivityList activities = new ActivityList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return activities.create((Map)params);
    }

    public Activity createActivity(List<NameValuePair> params) throws TwilioRestException {
        ActivityList activities = new ActivityList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return activities.create((List)params);
    }

    public Date getDateCreated() {
        return this.parseIsoDate(this.getProperty("date_created"));
    }

    public Date getDateUpdated() {
        return this.parseIsoDate(this.getProperty("date_updated"));
    }

    public String getDefaultActivityName() {
        return this.getProperty("default_activity_name");
    }

    public String getDefaultActivitySid() {
        return this.getProperty("default_activity_sid");
    }

    public Event getEvent(String eventSid) {
        Event event = new Event((TwilioTaskRouterClient)this.getClient(), this.getSid(), eventSid);
        return event;
    }

    public EventList getEvents() {
        EventList events = new EventList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return events;
    }

    public EventList getEvents(Calendar startDate, Calendar endDate, Integer minutes, Map<String, String> filters) {
        if (filters == null) {
            filters = new HashMap<String, String>();
        }
        if (startDate != null) {
            filters.put("StartDate", this.formatCalendar(startDate));
        }
        if (endDate != null) {
            filters.put("EndDate", this.formatCalendar(endDate));
        }
        if (minutes != null) {
            filters.put("Minutes", minutes.toString());
        }
        return this.getEvents(filters);
    }

    public EventList getEvents(Map<String, String> filters) {
        EventList events = new EventList((TwilioTaskRouterClient)this.getClient(), this.getSid(), filters);
        return events;
    }

    public String getEventCallbackUrl() {
        return this.getProperty("event_callback_url");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public Task getTask(String taskSid) {
        Task task = new Task((TwilioTaskRouterClient)this.getClient(), this.getSid(), taskSid);
        return task;
    }

    public TaskList getTasks() {
        TaskList tasks = new TaskList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return tasks;
    }

    public TaskList getTasks(Map<String, String> filters) {
        TaskList tasks = new TaskList((TwilioTaskRouterClient)this.getClient(), this.getSid(), filters);
        return tasks;
    }

    public Task createTask(Map<String, String> params) throws TwilioRestException {
        TaskList tasks = new TaskList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return tasks.create((Map)params);
    }

    public Task createTask(List<NameValuePair> params) throws TwilioRestException {
        TaskList tasks = new TaskList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return tasks.create((List)params);
    }

    public Task createTask(String workflowSid, Map<String, String> attributes, Integer priority, Integer timeout) throws TwilioRestException {
        TaskList tasks = new TaskList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return tasks.create(workflowSid, attributes, priority, timeout);
    }

    public String getTimeoutActivityName() {
        return this.getProperty("timeout_activity_name");
    }

    public String getTimeoutActivitySid() {
        return this.getProperty("timeout_activity_sid");
    }

    public Worker getWorker(String workerSid) {
        Worker worker = new Worker((TwilioTaskRouterClient)this.getClient(), this.getSid(), workerSid);
        return worker;
    }

    public WorkerList getWorkers() {
        WorkerList workers = new WorkerList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return workers;
    }

    public WorkerList getWorkers(Map<String, String> filters) {
        WorkerList workers = new WorkerList((TwilioTaskRouterClient)this.getClient(), this.getSid(), filters);
        return workers;
    }

    public Worker createWorker(Map<String, String> params) throws TwilioRestException {
        WorkerList workers = new WorkerList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return workers.create((Map)params);
    }

    public Worker createWorker(List<NameValuePair> params) throws TwilioRestException {
        WorkerList workers = new WorkerList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return workers.create((List)params);
    }

    public Worker createWorker(String friendlyName, Map<String, String> attributes, String activitySid) throws TwilioRestException {
        WorkerList workers = new WorkerList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return workers.create(friendlyName, attributes, activitySid);
    }

    public Workflow getWorkflow(String workflowSid) {
        Workflow workflow = new Workflow((TwilioTaskRouterClient)this.getClient(), this.getSid(), workflowSid);
        return workflow;
    }

    public WorkflowList getWorkflows() {
        WorkflowList workflows = new WorkflowList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return workflows;
    }

    public WorkflowList getWorkflows(Map<String, String> filters) {
        WorkflowList workflows = new WorkflowList((TwilioTaskRouterClient)this.getClient(), this.getSid(), filters);
        return workflows;
    }

    public Workflow createWorkflow(Map<String, String> params) throws TwilioRestException {
        WorkflowList workflows = new WorkflowList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return workflows.create((Map)params);
    }

    public Workflow createWorkflow(List<NameValuePair> params) throws TwilioRestException {
        WorkflowList workflows = new WorkflowList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return workflows.create((List)params);
    }

    public TaskQueue getTaskQueue(String taskQueueSid) {
        TaskQueue taskQueue = new TaskQueue((TwilioTaskRouterClient)this.getClient(), this.getSid(), taskQueueSid);
        return taskQueue;
    }

    public TaskQueueList getTaskQueues() {
        TaskQueueList taskQueues = new TaskQueueList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return taskQueues;
    }

    public TaskQueueList getTaskQueues(Map<String, String> filters) {
        TaskQueueList taskQueues = new TaskQueueList((TwilioTaskRouterClient)this.getClient(), this.getSid(), filters);
        return taskQueues;
    }

    public TaskQueue createTaskQueue(Map<String, String> params) throws TwilioRestException {
        TaskQueueList taskQueues = new TaskQueueList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return taskQueues.create((Map)params);
    }

    public TaskQueue createTaskQueue(List<NameValuePair> params) throws TwilioRestException {
        TaskQueueList taskQueues = new TaskQueueList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return taskQueues.create((List)params);
    }

    public WorkspaceStatistics getStatistics() {
        return this.getStatistics(new HashMap<String, String>());
    }

    public WorkspaceStatistics getStatistics(StatisticsQueryBuilder queryBuilder) {
        HashMap<String, String> filters = new HashMap<String, String>();
        Calendar startDate = queryBuilder.getStartDate();
        Calendar endDate = queryBuilder.getEndDate();
        Integer minutes = queryBuilder.getMinutes();
        if (startDate != null) {
            filters.put("StartDate", this.formatCalendar(startDate));
        }
        if (endDate != null) {
            filters.put("EndDate", this.formatCalendar(endDate));
        }
        if (minutes != null) {
            filters.put("Minutes", minutes.toString());
        }
        return this.getStatistics(filters);
    }

    public WorkspaceStatistics getStatistics(Map<String, String> filters) {
        String startDate = filters.get("StartDate");
        String endDate = filters.get("EndDate");
        String minutes = filters.get("Minutes");
        if ((startDate != null || endDate != null) && minutes != null) {
            throw new IllegalArgumentException("Cannot provide Minutes in combination with StartDate or EndDate");
        }
        WorkspaceStatistics statistics = new WorkspaceStatistics((TwilioTaskRouterClient)this.getClient(), this.getSid(), filters);
        return statistics;
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getSid();
    }
}

