/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.pricing;

import com.twilio.sdk.TwilioPricingClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.pricing.NumberType;
import java.math.BigDecimal;
import java.util.Map;

public class VoiceNumber
extends NextGenInstanceResource<TwilioPricingClient> {
    public VoiceNumber(TwilioPricingClient client) {
        super(client);
    }

    public VoiceNumber(TwilioPricingClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public VoiceNumber(TwilioPricingClient client, String number) {
        super(client);
        if (number == null || "".equals(number)) {
            throw new IllegalArgumentException("'number' cannot be null");
        }
        this.setProperty("number", number);
    }

    public String getNumber() {
        return this.getProperty("number");
    }

    public String getCountry() {
        return this.getProperty("country");
    }

    public String getIsoCountry() {
        return this.getProperty("iso_country");
    }

    public String getPriceUnit() {
        return this.getProperty("price_unit");
    }

    public OutboundCallPrice getOutboundCallPrice() {
        Map prices = (Map)this.getObject("outbound_call_price");
        return new OutboundCallPrice(new BigDecimal((String)prices.get("base_price")), new BigDecimal((String)prices.get("current_price")));
    }

    public InboundCallPrice getInboundCallPrice() {
        Map priceInfo = (Map)this.getObject("inbound_call_price");
        if (priceInfo == null) {
            return null;
        }
        return new InboundCallPrice(NumberType.valueOf(((String)priceInfo.get("number_type")).toUpperCase()), new BigDecimal((String)priceInfo.get("base_price")), new BigDecimal((String)priceInfo.get("current_price")));
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Voice/Numbers/" + this.getNumber();
    }

    public class InboundCallPrice {
        private final NumberType numberType;
        private final BigDecimal basePrice;
        private final BigDecimal currentPrice;

        public InboundCallPrice(NumberType numberType, BigDecimal basePrice, BigDecimal currentPrice) {
            this.numberType = numberType;
            this.basePrice = basePrice;
            this.currentPrice = currentPrice;
        }

        public NumberType getNumberType() {
            return this.numberType;
        }

        public BigDecimal getBasePrice() {
            return this.basePrice;
        }

        public BigDecimal getCurrentPrice() {
            return this.currentPrice;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InboundCallPrice that = (InboundCallPrice)o;
            if (!this.basePrice.equals(that.basePrice)) {
                return false;
            }
            if (!this.currentPrice.equals(that.currentPrice)) {
                return false;
            }
            return this.numberType.equals((Object)that.numberType);
        }

        public int hashCode() {
            int result = this.numberType.hashCode();
            result = 31 * result + this.basePrice.hashCode();
            result = 31 * result + this.currentPrice.hashCode();
            return result;
        }
    }

    public class OutboundCallPrice {
        private final BigDecimal basePrice;
        private final BigDecimal currentPrice;

        public OutboundCallPrice(BigDecimal basePrice, BigDecimal currentPrice) {
            this.basePrice = basePrice;
            this.currentPrice = currentPrice;
        }

        public BigDecimal getBasePrice() {
            return this.basePrice;
        }

        public BigDecimal getCurrentPrice() {
            return this.currentPrice;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutboundCallPrice that = (OutboundCallPrice)o;
            if (!this.basePrice.equals(that.basePrice)) {
                return false;
            }
            return this.currentPrice.equals(that.currentPrice);
        }

        public int hashCode() {
            int result = this.basePrice.hashCode();
            result = 31 * result + this.currentPrice.hashCode();
            return result;
        }
    }
}

