/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.pricing;

import com.twilio.sdk.TwilioPricingClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.pricing.NumberType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class MessagingCountry
extends NextGenInstanceResource<TwilioPricingClient> {
    public MessagingCountry(TwilioPricingClient client) {
        this(client, (Map<String, Object>)new HashMap<String, Object>());
    }

    public MessagingCountry(TwilioPricingClient client, String isoCountry) {
        super(client);
        if (StringUtils.isBlank((CharSequence)isoCountry)) {
            throw new IllegalArgumentException("The isoCountry for a MessagingCountry cannot be blank");
        }
        this.setProperty("iso_country", isoCountry);
    }

    public MessagingCountry(TwilioPricingClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Messaging/Countries/" + this.getIsoCountry();
    }

    public String getCountry() {
        return this.getProperty("country");
    }

    public String getIsoCountry() {
        return this.getProperty("iso_country");
    }

    public String getPriceUnit() {
        return this.getProperty("price_unit");
    }

    public List<OutboundSmsPrice> getOutboundSmsPrices() {
        List priceData = (List)this.getCastedObject("outbound_sms_prices");
        ArrayList<OutboundSmsPrice> details = new ArrayList<OutboundSmsPrice>();
        for (Map data : priceData) {
            details.add(new OutboundSmsPrice(data.get("mcc").toString(), data.get("mnc").toString(), data.get("carrier").toString(), this.getMessagingPrices((List)data.get("prices"))));
        }
        return details;
    }

    public List<MessagingPrice> getInboundSmsPrices() {
        List priceData = (List)this.getCastedObject("inbound_sms_prices");
        return this.getMessagingPrices(priceData);
    }

    private List<MessagingPrice> getMessagingPrices(List<Map<String, String>> priceData) {
        ArrayList<MessagingPrice> prices = new ArrayList<MessagingPrice>();
        for (Map<String, String> p : priceData) {
            prices.add(new MessagingPrice(NumberType.valueOf(p.get("number_type").toUpperCase()), new BigDecimal(p.get("base_price")), new BigDecimal(p.get("current_price"))));
        }
        return prices;
    }

    public class MessagingPrice {
        private final NumberType numberType;
        private final BigDecimal basePrice;
        private final BigDecimal currentPrice;

        public MessagingPrice(NumberType numberType, BigDecimal basePrice, BigDecimal currentPrice) {
            this.numberType = numberType;
            this.basePrice = basePrice;
            this.currentPrice = currentPrice;
        }

        public NumberType getNumberType() {
            return this.numberType;
        }

        public BigDecimal getBasePrice() {
            return this.basePrice;
        }

        public BigDecimal getCurrentPrice() {
            return this.currentPrice;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MessagingPrice that = (MessagingPrice)o;
            return new EqualsBuilder().append((Object)this.basePrice, (Object)that.basePrice).append((Object)this.currentPrice, (Object)that.currentPrice).append((Object)this.numberType, (Object)that.numberType).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.numberType).append((Object)this.basePrice).append((Object)this.currentPrice).toHashCode();
        }
    }

    public class OutboundSmsPrice {
        private final String mcc;
        private final String mnc;
        private final String carrier;
        private final List<MessagingPrice> prices;

        public OutboundSmsPrice(String mcc, String mnc, String carrier, List<MessagingPrice> prices) {
            this.mcc = mcc;
            this.mnc = mnc;
            this.carrier = carrier;
            this.prices = prices;
        }

        public String getMcc() {
            return this.mcc;
        }

        public String getMnc() {
            return this.mnc;
        }

        public String getCarrier() {
            return this.carrier;
        }

        public List<MessagingPrice> getPrices() {
            return this.prices;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.mcc).append((Object)this.mnc).append((Object)this.carrier).append(this.prices).toHashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            OutboundSmsPrice o = (OutboundSmsPrice)obj;
            return new EqualsBuilder().append((Object)this.mcc, (Object)o.mcc).append((Object)this.mnc, (Object)o.mnc).append((Object)this.carrier, (Object)o.carrier).append(this.prices, o.prices).isEquals();
        }
    }
}

