/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.verbs;

import com.twilio.sdk.verbs.TwiMLException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringEscapeUtils;

public class Verb {
    protected String tag;
    protected String body;
    protected HashMap<String, String> attributes;
    protected ArrayList<Verb> children;
    protected ArrayList<String> allowedVerbs;
    public static final String V_BODY = "Body";
    public static final String V_CLIENT = "Client";
    public static final String V_CONFERENCE = "Conference";
    public static final String V_DIAL = "Dial";
    public static final String V_ENQUEUE = "Enqueue";
    public static final String V_TASK = "Task";
    public static final String V_GATHER = "Gather";
    public static final String V_HANGUP = "Hangup";
    public static final String V_LEAVE = "Leave";
    public static final String V_MEDIA = "Media";
    public static final String V_MESSAGE = "Message";
    public static final String V_NUMBER = "Number";
    public static final String V_PAUSE = "Pause";
    public static final String V_PLAY = "Play";
    public static final String V_QUEUE = "Queue";
    public static final String V_RECORD = "Record";
    public static final String V_REDIRECT = "Redirect";
    public static final String V_REJECT = "Reject";
    public static final String V_RESPONSE = "Response";
    public static final String V_SAY = "Say";
    public static final String V_SIP = "Sip";
    public static final String V_SMS = "Sms";
    public static final String V_URI = "Uri";

    public Verb(String tag, String body) {
        this.tag = tag;
        this.body = body;
        this.attributes = new LinkedHashMap<String, String>();
        this.children = new ArrayList();
    }

    public Verb append(Verb verb) throws TwiMLException {
        if (this.allowedVerbs != null && this.allowedVerbs.contains(verb.getTag())) {
            this.children.add(verb);
            return verb;
        }
        throw new TwiMLException("This is not a supported verb");
    }

    public String toXML() {
        return this.toXML(false);
    }

    private String toXML(boolean escape) {
        String xml = "<" + this.tag;
        for (String key : this.attributes.keySet()) {
            xml = xml + " " + key + "=\"" + this.attributes.get(key) + "\"";
        }
        xml = xml + ">";
        if (this.body != null) {
            String body = escape ? StringEscapeUtils.escapeXml((String)this.body) : this.body;
            xml = xml + body;
        }
        for (Verb child : this.children) {
            xml = xml + child.toXML(escape);
        }
        xml = xml + "</" + this.tag + ">";
        return xml;
    }

    public String toEscapedXML() {
        return this.toXML(true);
    }

    public String asURL() {
        try {
            return URLEncoder.encode(this.toXML(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void set(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getBody() {
        return this.body;
    }

    public String getTag() {
        return this.tag;
    }

    public ArrayList<Verb> getChildren() {
        return this.children;
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }
}

