/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list.trunking;

import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.TwilioTrunkingClient;
import com.twilio.sdk.resource.NextGenListResource;
import com.twilio.sdk.resource.factory.ResourceFactory;
import com.twilio.sdk.resource.instance.trunking.CredentialList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;

public class CredentialListList
extends NextGenListResource<CredentialList, TwilioTrunkingClient>
implements ResourceFactory<CredentialList> {
    private final String trunkSid;

    public CredentialListList(TwilioTrunkingClient client, String trunkSid) {
        this(client, trunkSid, null);
    }

    public CredentialListList(TwilioTrunkingClient client, String trunkSid, Map<String, String> filters) {
        super(client, filters);
        if (StringUtils.isEmpty((CharSequence)trunkSid)) {
            throw new IllegalArgumentException("trunkSid cannot be null");
        }
        this.trunkSid = trunkSid;
    }

    @Override
    protected CredentialList makeNew(TwilioTrunkingClient client, Map<String, Object> params) {
        return new CredentialList(client, params);
    }

    @Override
    public CredentialList create(Map<String, String> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioTrunkingClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioTrunkingClient)this.getClient(), response.toMap());
    }

    @Override
    public CredentialList create(List<NameValuePair> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioTrunkingClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioTrunkingClient)this.getClient(), response.toMap());
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Trunks/" + this.trunkSid + "/CredentialLists";
    }
}

