/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.sip;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.factory.sip.IpAddressFactory;
import com.twilio.sdk.resource.instance.sip.IpAddress;
import com.twilio.sdk.resource.list.sip.IpAddressList;
import java.util.Date;
import java.util.Map;

public class IpAccessControlList
extends InstanceResource<TwilioRestClient> {
    public IpAccessControlList(TwilioRestClient client) {
        super(client);
    }

    public IpAccessControlList(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a IpAccessControlList can not be null");
        }
        this.setProperty("sid", sid);
    }

    public IpAccessControlList(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/SIP/IpAccessControlLists/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public Date getDateCreated() {
        return this.getDateProperty("date_created");
    }

    public Date getDateUpdated() {
        return this.getDateProperty("date_updated");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public IpAddressList getIpAddresses() {
        IpAddressList ipAddressList = new IpAddressList((TwilioRestClient)this.getClient(), this.getSid());
        ipAddressList.setRequestAccountSid(this.getRequestAccountSid());
        return ipAddressList;
    }

    public IpAddressFactory getIpAddressFactory() {
        return this.getIpAddresses();
    }

    public IpAddress getIpAddress(String ipAddressSid) {
        IpAddress ipAddress = new IpAddress((TwilioRestClient)this.getClient(), this.getSid(), ipAddressSid);
        ipAddress.setRequestAccountSid(this.getRequestAccountSid());
        return ipAddress;
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

