/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.sip;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import java.util.Date;
import java.util.Map;

public class Credential
extends InstanceResource<TwilioRestClient> {
    private String requestCredentialListSid;

    public Credential(TwilioRestClient client) {
        super(client);
    }

    public Credential(TwilioRestClient client, String credentialListSid, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a Credential can not be null");
        }
        this.setProperty("sid", sid);
        this.requestCredentialListSid = credentialListSid;
    }

    public Credential(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/SIP/CredentialLists/" + this.getRequestCredentialListSid() + "/Credentials/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public Date getDateCreated() {
        return this.getDateProperty("date_created");
    }

    public Date getDateUpdated() {
        return this.getDateProperty("date_updated");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getUsername() {
        return this.getProperty("username");
    }

    public String getRequestCredentialListSid() {
        return this.requestCredentialListSid;
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

