/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.factory.AddressFactory;
import com.twilio.sdk.resource.factory.ApplicationFactory;
import com.twilio.sdk.resource.factory.CallFactory;
import com.twilio.sdk.resource.factory.IncomingPhoneNumberFactory;
import com.twilio.sdk.resource.factory.MessageFactory;
import com.twilio.sdk.resource.factory.OutgoingCallerIdFactory;
import com.twilio.sdk.resource.factory.QueueFactory;
import com.twilio.sdk.resource.factory.SmsFactory;
import com.twilio.sdk.resource.factory.UsageTriggerFactory;
import com.twilio.sdk.resource.factory.sip.CredentialListFactory;
import com.twilio.sdk.resource.factory.sip.DomainFactory;
import com.twilio.sdk.resource.factory.sip.IpAccessControlListFactory;
import com.twilio.sdk.resource.instance.Address;
import com.twilio.sdk.resource.instance.Application;
import com.twilio.sdk.resource.instance.AuthorizedConnectApp;
import com.twilio.sdk.resource.instance.Call;
import com.twilio.sdk.resource.instance.Conference;
import com.twilio.sdk.resource.instance.ConnectApp;
import com.twilio.sdk.resource.instance.FeedbackSummary;
import com.twilio.sdk.resource.instance.IncomingPhoneNumber;
import com.twilio.sdk.resource.instance.Key;
import com.twilio.sdk.resource.instance.Media;
import com.twilio.sdk.resource.instance.Message;
import com.twilio.sdk.resource.instance.Notification;
import com.twilio.sdk.resource.instance.OutgoingCallerId;
import com.twilio.sdk.resource.instance.Queue;
import com.twilio.sdk.resource.instance.Recording;
import com.twilio.sdk.resource.instance.Sandbox;
import com.twilio.sdk.resource.instance.ShortCode;
import com.twilio.sdk.resource.instance.Sms;
import com.twilio.sdk.resource.instance.Transcription;
import com.twilio.sdk.resource.instance.UsageTrigger;
import com.twilio.sdk.resource.instance.sip.CredentialListInstance;
import com.twilio.sdk.resource.instance.sip.Domain;
import com.twilio.sdk.resource.instance.sip.IpAccessControlList;
import com.twilio.sdk.resource.list.AddressList;
import com.twilio.sdk.resource.list.ApplicationList;
import com.twilio.sdk.resource.list.AuthorizedConnectAppList;
import com.twilio.sdk.resource.list.AvailablePhoneNumberList;
import com.twilio.sdk.resource.list.CallList;
import com.twilio.sdk.resource.list.ConferenceList;
import com.twilio.sdk.resource.list.ConnectAppList;
import com.twilio.sdk.resource.list.IncomingPhoneNumberList;
import com.twilio.sdk.resource.list.KeyList;
import com.twilio.sdk.resource.list.MediaList;
import com.twilio.sdk.resource.list.MessageList;
import com.twilio.sdk.resource.list.NotificationList;
import com.twilio.sdk.resource.list.OutgoingCallerIdList;
import com.twilio.sdk.resource.list.QueueList;
import com.twilio.sdk.resource.list.RecordingList;
import com.twilio.sdk.resource.list.ShortCodeList;
import com.twilio.sdk.resource.list.SmsList;
import com.twilio.sdk.resource.list.TokenList;
import com.twilio.sdk.resource.list.TranscriptionList;
import com.twilio.sdk.resource.list.UsageRecordList;
import com.twilio.sdk.resource.list.UsageTriggerList;
import com.twilio.sdk.resource.list.sip.CredentialListList;
import com.twilio.sdk.resource.list.sip.DomainList;
import com.twilio.sdk.resource.list.sip.IpAccessControlListList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Account
extends InstanceResource<TwilioRestClient> {
    private static final String STATUS_PROPERTY = "status";
    private static final String TYPE_PROPERTY = "type";
    private static final String FRIENDLY_NAME_PROPERTY = "friendly_name";
    private static final String AUTH_TOKEN_PROPERTY = "auth_token";

    public Account(TwilioRestClient client) {
        super(client);
    }

    public Account(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
        Object ac = properties.get("sid");
        if (ac != null && ac instanceof String) {
            String accountSid = (String)ac;
            this.setRequestAccountSid(accountSid);
        }
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public void setSid(String accountSid) {
        this.setRequestAccountSid(accountSid);
        this.setProperty("sid", accountSid);
    }

    public String getAuthToken() {
        return this.getProperty(AUTH_TOKEN_PROPERTY);
    }

    public void setAuthToken(String authToken) {
        this.setProperty(AUTH_TOKEN_PROPERTY, authToken);
    }

    public String getFriendlyName() {
        return this.getProperty(FRIENDLY_NAME_PROPERTY);
    }

    public String getStatus() {
        return this.getProperty(STATUS_PROPERTY);
    }

    public String getType() {
        return this.getProperty(TYPE_PROPERTY);
    }

    public Date getDateCreated() {
        return this.getDateProperty("date_created");
    }

    public Date getDateUpdated() {
        return this.getDateProperty("date_updated");
    }

    @Override
    protected String getResourceLocation() {
        return this.getResourceLocation(".json");
    }

    private String getResourceLocation(String extension) {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + extension;
    }

    public CallList getCalls() {
        return this.getCalls(new HashMap<String, String>());
    }

    public CallList getCalls(Map<String, String> filters) {
        CallList calls = new CallList((TwilioRestClient)this.getClient(), filters);
        calls.setRequestAccountSid(this.getRequestAccountSid());
        return calls;
    }

    public Call getCall(String sid) {
        Call call = new Call((TwilioRestClient)this.getClient(), sid);
        call.setRequestAccountSid(this.getRequestAccountSid());
        return call;
    }

    public CallFactory getCallFactory() {
        return this.getCalls();
    }

    public SmsList getSmsMessages() {
        return this.getSmsMessages(new HashMap<String, String>());
    }

    public SmsList getSmsMessages(Map<String, String> filters) {
        SmsList sms = new SmsList((TwilioRestClient)this.getClient(), filters);
        sms.setRequestAccountSid(this.getRequestAccountSid());
        return sms;
    }

    public Sms getSms(String sid) {
        Sms sms = new Sms((TwilioRestClient)this.getClient(), sid);
        sms.setRequestAccountSid(this.getRequestAccountSid());
        return sms;
    }

    public SmsFactory getSmsFactory() {
        return this.getSmsMessages();
    }

    public MessageList getMessages() {
        return this.getMessages(new HashMap<String, String>());
    }

    public MessageList getMessages(Map<String, String> filters) {
        MessageList messages = new MessageList((TwilioRestClient)this.getClient(), filters);
        messages.setRequestAccountSid(this.getRequestAccountSid());
        return messages;
    }

    public MessageFactory getMessageFactory() {
        return this.getMessages();
    }

    public Message getMessage(String sid) {
        Message message = new Message((TwilioRestClient)this.getClient(), sid);
        message.setRequestAccountSid(this.getRequestAccountSid());
        return message;
    }

    public MediaList getMedia() {
        return this.getMedia(new HashMap<String, String>());
    }

    public MediaList getMedia(Map<String, String> filters) {
        MediaList mediaList = new MediaList((TwilioRestClient)this.getClient(), filters);
        mediaList.setRequestAccountSid(this.getRequestAccountSid());
        return mediaList;
    }

    public Media getMedia(String sid) {
        Media media = new Media((TwilioRestClient)this.getClient(), sid);
        media.setRequestAccountSid(this.getRequestAccountSid());
        return media;
    }

    public ApplicationList getApplications() {
        return this.getApplications(new HashMap<String, String>());
    }

    public ApplicationList getApplications(Map<String, String> filters) {
        ApplicationList list = new ApplicationList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Application getApplication(String sid) {
        Application app = new Application((TwilioRestClient)this.getClient(), sid);
        app.setRequestAccountSid(this.getRequestAccountSid());
        return app;
    }

    public ApplicationFactory getApplicationFactory() {
        return this.getApplications();
    }

    public AvailablePhoneNumberList getAvailablePhoneNumbers() {
        return this.getAvailablePhoneNumbers(new HashMap<String, String>());
    }

    public AvailablePhoneNumberList getAvailablePhoneNumbers(Map<String, String> filters) {
        AvailablePhoneNumberList list = new AvailablePhoneNumberList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public AvailablePhoneNumberList getAvailablePhoneNumbers(Map<String, String> filters, String isoCountry, String type) {
        AvailablePhoneNumberList list = new AvailablePhoneNumberList((TwilioRestClient)this.getClient(), filters, isoCountry, type);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public ConferenceList getConferences() {
        return this.getConferences(new HashMap<String, String>());
    }

    public ConferenceList getConferences(Map<String, String> filters) {
        ConferenceList list = new ConferenceList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Conference getConference(String sid) {
        Conference conf = new Conference((TwilioRestClient)this.getClient(), sid);
        conf.setRequestAccountSid(this.getRequestAccountSid());
        return conf;
    }

    public QueueList getQueues() {
        QueueList list = new QueueList((TwilioRestClient)this.getClient(), (Map<String, String>)this.filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Queue getQueue(String sid) {
        Queue queue = new Queue((TwilioRestClient)this.getClient(), sid);
        queue.setRequestAccountSid(this.getRequestAccountSid());
        return queue;
    }

    public QueueFactory getQueueFactory() {
        return this.getQueues();
    }

    public IncomingPhoneNumberList getIncomingPhoneNumbers() {
        return this.getIncomingPhoneNumbers(new HashMap<String, String>());
    }

    public IncomingPhoneNumberList getIncomingPhoneNumbers(Map<String, String> filters) {
        IncomingPhoneNumberList list = new IncomingPhoneNumberList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public IncomingPhoneNumber getIncomingPhoneNumber(String sid) {
        IncomingPhoneNumber pn = new IncomingPhoneNumber((TwilioRestClient)this.getClient(), sid);
        pn.setRequestAccountSid(this.getRequestAccountSid());
        return pn;
    }

    public IncomingPhoneNumberFactory getIncomingPhoneNumberFactory() {
        return this.getIncomingPhoneNumbers();
    }

    public AddressList getAddresses(Map<String, String> filters) {
        AddressList list = new AddressList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public AddressList getAddresses() {
        return this.getAddresses(new HashMap<String, String>());
    }

    public AddressFactory getAddressFactory() {
        return this.getAddresses();
    }

    public Address getAddress(String sid) {
        Address address = new Address((TwilioRestClient)this.getClient(), sid);
        address.setRequestAccountSid(this.getRequestAccountSid());
        return address;
    }

    public ShortCodeList getShortCodes() {
        return this.getShortCodes(new HashMap<String, String>());
    }

    public ShortCodeList getShortCodes(Map<String, String> filters) {
        ShortCodeList list = new ShortCodeList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public ShortCode getShortCode(String sid) {
        ShortCode sc = new ShortCode((TwilioRestClient)this.getClient(), sid);
        sc.setRequestAccountSid(this.getRequestAccountSid());
        return sc;
    }

    public Key getKey(String sid) {
        Key key = new Key((TwilioRestClient)this.getClient(), sid);
        key.setRequestAccountSid(this.getRequestAccountSid());
        return key;
    }

    public KeyList getKeys() {
        return this.getKeys(null);
    }

    public KeyList getKeys(Map<String, String> filters) {
        KeyList list = new KeyList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public NotificationList getNotifications() {
        return this.getNotifications(new HashMap<String, String>());
    }

    public NotificationList getNotifications(Map<String, String> filters) {
        NotificationList list = new NotificationList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Notification getNotification(String sid) {
        Notification n = new Notification((TwilioRestClient)this.getClient(), sid);
        n.setRequestAccountSid(this.getRequestAccountSid());
        return n;
    }

    public OutgoingCallerIdList getOutgoingCallerIds() {
        return this.getOutgoingCallerIds(new HashMap<String, String>());
    }

    public OutgoingCallerIdList getOutgoingCallerIds(Map<String, String> filters) {
        OutgoingCallerIdList list = new OutgoingCallerIdList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public OutgoingCallerId getOutgoingCallerId(String sid) {
        OutgoingCallerId number = new OutgoingCallerId((TwilioRestClient)this.getClient(), sid);
        number.setRequestAccountSid(this.getRequestAccountSid());
        return number;
    }

    public OutgoingCallerIdFactory getOutgoingCallerIdFactory() {
        return this.getOutgoingCallerIds();
    }

    public RecordingList getRecordings() {
        return this.getRecordings(new HashMap<String, String>());
    }

    public RecordingList getRecordings(Map<String, String> filters) {
        RecordingList list = new RecordingList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Recording getRecording(String sid) {
        Recording r = new Recording((TwilioRestClient)this.getClient(), sid);
        r.setRequestAccountSid(this.getRequestAccountSid());
        return r;
    }

    public TranscriptionList getTranscriptions() {
        return this.getTranscriptions(new HashMap<String, String>());
    }

    public TranscriptionList getTranscriptions(Map<String, String> filters) {
        TranscriptionList list = new TranscriptionList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Transcription getTranscription(String sid) {
        Transcription tr = new Transcription((TwilioRestClient)this.getClient(), sid);
        tr.setRequestAccountSid(this.getRequestAccountSid());
        return tr;
    }

    public UsageRecordList getUsageRecords(Map<String, String> filters) {
        UsageRecordList list = new UsageRecordList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public UsageRecordList getUsageRecords() {
        return this.getUsageRecords(new HashMap<String, String>());
    }

    public UsageRecordList getUsageRecords(UsageRecordList.Type type) {
        return this.getUsageRecords(new HashMap<String, String>(), type);
    }

    public UsageRecordList getUsageRecords(Map<String, String> filters, UsageRecordList.Type type) {
        UsageRecordList list = new UsageRecordList((TwilioRestClient)this.getClient(), filters, type);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public UsageTrigger getUsageTrigger(String sid) {
        UsageTrigger trigger = new UsageTrigger((TwilioRestClient)this.getClient(), sid);
        trigger.setRequestAccountSid(this.getRequestAccountSid());
        return trigger;
    }

    public UsageTriggerFactory getUsageTriggerFactory() {
        return this.getUsageTriggers();
    }

    public UsageTriggerList getUsageTriggers(Map<String, String> filters) {
        UsageTriggerList list = new UsageTriggerList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public UsageTriggerList getUsageTriggers() {
        return this.getUsageTriggers(new HashMap<String, String>());
    }

    public ConnectAppList getConnectApps() {
        return this.getConnectApps(new HashMap<String, String>());
    }

    public ConnectAppList getConnectApps(Map<String, String> filters) {
        ConnectAppList list = new ConnectAppList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public ConnectApp getConnectApp(String sid) {
        ConnectApp cn = new ConnectApp((TwilioRestClient)this.getClient(), sid);
        cn.setRequestAccountSid(this.getRequestAccountSid());
        return cn;
    }

    public AuthorizedConnectAppList getAuthorizedConnectApps() {
        return this.getAuthorizedConnectApps(new HashMap<String, String>());
    }

    public AuthorizedConnectAppList getAuthorizedConnectApps(Map<String, String> filters) {
        AuthorizedConnectAppList list = new AuthorizedConnectAppList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public AuthorizedConnectApp getAuthorizedConnectApp(String sid) {
        AuthorizedConnectApp cn = new AuthorizedConnectApp((TwilioRestClient)this.getClient(), sid);
        cn.setRequestAccountSid(this.getRequestAccountSid());
        return cn;
    }

    public DomainList getDomains() {
        return this.getDomains(new HashMap<String, String>());
    }

    public DomainList getDomains(Map<String, String> filters) {
        DomainList list = new DomainList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Domain getDomain(String sid) {
        Domain domain = new Domain((TwilioRestClient)this.getClient(), sid);
        domain.setRequestAccountSid(this.getRequestAccountSid());
        return domain;
    }

    public DomainFactory getDomainFactory() {
        return this.getDomains();
    }

    public IpAccessControlListList getIpAccessControlLists() {
        return this.getIpAccessControlLists(new HashMap<String, String>());
    }

    public IpAccessControlListList getIpAccessControlLists(Map<String, String> filters) {
        IpAccessControlListList list = new IpAccessControlListList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public IpAccessControlList getIpAccessControlList(String sid) {
        IpAccessControlList ipAccessControlList = new IpAccessControlList((TwilioRestClient)this.getClient(), sid);
        ipAccessControlList.setRequestAccountSid(this.getRequestAccountSid());
        return ipAccessControlList;
    }

    public IpAccessControlListFactory getIpAccessControlListFactory() {
        return this.getIpAccessControlLists();
    }

    public CredentialListList getCredentialLists() {
        return this.getCredentialLists(new HashMap<String, String>());
    }

    public CredentialListList getCredentialLists(Map<String, String> filters) {
        CredentialListList list = new CredentialListList((TwilioRestClient)this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public CredentialListInstance getCredentialList(String sid) {
        CredentialListInstance credentialList = new CredentialListInstance((TwilioRestClient)this.getClient(), sid);
        credentialList.setRequestAccountSid(this.getRequestAccountSid());
        return credentialList;
    }

    public CredentialListFactory getCredentialListFactory() {
        return this.getCredentialLists();
    }

    public Sandbox getSandbox() {
        Sandbox sb = new Sandbox((TwilioRestClient)this.getClient());
        sb.setRequestAccountSid(this.getRequestAccountSid());
        return sb;
    }

    public boolean close() throws TwilioRestException {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("Status", "closed");
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", vars);
        return !response.isError();
    }

    public FeedbackSummary createFeedbackSummary(Map<String, String> filters) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation("") + "/Calls/FeedbackSummary.json", "POST", filters);
        return new FeedbackSummary((TwilioRestClient)this.getClient(), response.toMap());
    }

    public void deleteFeedbackSummary(String sid) throws TwilioRestException {
        ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation("") + "/Calls/FeedbackSummary/" + sid + ".json", "DELETE", (Map<String, String>)null);
    }

    public FeedbackSummary getFeedbackSummary(String sid) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation("") + "/Calls/FeedbackSummary/" + sid + ".json", "GET", (Map<String, String>)null);
        return new FeedbackSummary((TwilioRestClient)this.getClient(), response.toMap());
    }

    public TokenList getTokenFactory() {
        TokenList tokens = new TokenList((TwilioRestClient)this.getClient());
        tokens.setRequestAccountSid(this.getRequestAccountSid());
        return tokens;
    }
}

