/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.parser;

import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.parser.ResponseParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonResponseParser
implements ResponseParser {
    @Override
    public Map<String, Object> parse(TwilioRestResponse response) {
        return this.parseJson(response.getResponseText());
    }

    protected Map<String, Object> parseJson(String jsonString) {
        Map<String, Object> ret = new HashMap<String, Object>();
        try {
            ret = (Map)new ObjectMapper().readValue(jsonString, HashMap.class);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public String getPagingPropertyKey(ResponseParser.PagingProperty prop) {
        switch (prop) {
            case NEXT_PAGE_URI_KEY: {
                return "next_page_uri";
            }
            case START_KEY: {
                return "start";
            }
            case END_KEY: {
                return "end";
            }
            case PAGE_KEY: {
                return "page";
            }
        }
        return null;
    }
}

