/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.taskrouter.Activity;
import com.twilio.sdk.resource.instance.taskrouter.Event;
import com.twilio.sdk.resource.instance.taskrouter.Task;
import com.twilio.sdk.resource.instance.taskrouter.Worker;
import com.twilio.sdk.resource.instance.taskrouter.Workflow;
import com.twilio.sdk.resource.list.taskrouter.ActivityList;
import com.twilio.sdk.resource.list.taskrouter.EventList;
import com.twilio.sdk.resource.list.taskrouter.TaskList;
import com.twilio.sdk.resource.list.taskrouter.WorkerList;
import com.twilio.sdk.resource.list.taskrouter.WorkflowList;
import java.util.Date;
import java.util.Map;

public class Workspace
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    public Workspace(TwilioTaskRouterClient client) {
        super(client);
    }

    public Workspace(TwilioTaskRouterClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Workspace(TwilioTaskRouterClient client, String sid) {
        super(client);
        if (sid == null || "".equals(sid)) {
            throw new IllegalArgumentException("The Sid for a Workspace cannot be null");
        }
        this.setProperty("sid", sid);
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public ActivityList getActivities() {
        ActivityList activities = new ActivityList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return activities;
    }

    public Activity getActivity(String activitySid) {
        Activity activity = new Activity((TwilioTaskRouterClient)this.getClient(), this.getSid(), activitySid);
        return activity;
    }

    public Date getDateCreated() {
        return this.parseDate(this.getProperty("date_created"));
    }

    public Date getDateUpdated() {
        return this.parseDate(this.getProperty("date_updated"));
    }

    public String getDefaultActivityName() {
        return this.getProperty("default_activity_name");
    }

    public String getDefaultActivitySid() {
        return this.getProperty("default_activity_sid");
    }

    public Event getEvent(String eventSid) {
        Event event = new Event((TwilioTaskRouterClient)this.getClient(), this.getSid(), eventSid);
        return event;
    }

    public EventList getEvents() {
        EventList events = new EventList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return events;
    }

    public String getEventCallbackUrl() {
        return this.getProperty("event_callback_url");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public Task getTask(String taskSid) {
        Task task = new Task((TwilioTaskRouterClient)this.getClient(), this.getSid(), taskSid);
        return task;
    }

    public TaskList getTasks() {
        TaskList tasks = new TaskList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return tasks;
    }

    public String getTimeoutActivityName() {
        return this.getProperty("timeout_activity_name");
    }

    public String getTimeoutActivitySid() {
        return this.getProperty("timeout_activity_sid");
    }

    public Worker getWorker(String workerSid) {
        Worker worker = new Worker((TwilioTaskRouterClient)this.getClient(), this.getSid(), workerSid);
        return worker;
    }

    public WorkerList getWorkers() {
        WorkerList workers = new WorkerList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return workers;
    }

    public Workflow getWorkflow(String workflowSid) {
        Workflow workflow = new Workflow((TwilioTaskRouterClient)this.getClient(), this.getSid(), workflowSid);
        return workflow;
    }

    public WorkflowList getWorkflows() {
        WorkflowList workflows = new WorkflowList((TwilioTaskRouterClient)this.getClient(), this.getSid());
        return workflows;
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getSid();
    }
}

