/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Date;
import java.util.Map;

public class Task
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";

    public Task(TwilioTaskRouterClient client) {
        super(client);
    }

    public Task(TwilioTaskRouterClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Task(TwilioTaskRouterClient client, String workspaceSid, String taskSid) {
        super(client);
        if (workspaceSid == null || "".equals(workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for an Task cannot be null");
        }
        if (taskSid == null || "".equals(taskSid)) {
            throw new IllegalArgumentException("The taskSid for an Task cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.setProperty("sid", taskSid);
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public int getAge() {
        Integer prop = (Integer)this.getObject("age");
        if (prop != null) {
            return prop;
        }
        throw new IllegalStateException("The Task doesn't have its age set");
    }

    public String getAssignmentStatus() {
        return this.getProperty("assignment_status");
    }

    public String getAttributes() {
        return this.getProperty("attributes");
    }

    public Date getDateCreated() {
        return this.parseDate(this.getProperty("date_created"));
    }

    public Date getDateUpdated() {
        return this.parseDate(this.getProperty("date_updated"));
    }

    public int getPriority() {
        Integer prop = (Integer)this.getObject("priority");
        if (prop != null) {
            return prop;
        }
        throw new IllegalStateException("The Task doesn't have its priority set");
    }

    public int getTimeout() {
        return (Integer)this.getObject("timeout");
    }

    public String getQueueSid() {
        return this.getProperty("task_queue_sid");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getWorkflowSid() {
        return this.getProperty("workflow_sid");
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    public String getReason() {
        return this.getProperty("reason");
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/Tasks/" + this.getSid();
    }
}

