/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource;

import com.twilio.sdk.TwilioClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import java.util.Map;

public abstract class Resource<C extends TwilioClient> {
    private C client;
    private String requestAccountSid;
    protected Map<String, String> filters;
    private boolean loaded;

    public Resource(C client) {
        this.client = client;
    }

    protected C getClient() {
        return this.client;
    }

    protected void load(Map<String, String> params) throws TwilioRestException {
        String path = this.getResourceLocation();
        TwilioRestResponse response = ((TwilioClient)this.getClient()).safeRequest(path, "GET", params);
        this.parseResponse(response);
        this.loaded = true;
    }

    protected abstract void parseResponse(TwilioRestResponse var1);

    protected boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    protected String getRequestAccountSid() {
        return this.requestAccountSid;
    }

    public void setRequestAccountSid(String sid) {
        this.requestAccountSid = sid;
    }

    protected abstract String getResourceLocation();
}

