/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk;

import com.twilio.sdk.TwilioClient;
import com.twilio.sdk.resource.factory.AccountFactory;
import com.twilio.sdk.resource.instance.Account;
import com.twilio.sdk.resource.list.AccountList;
import java.util.HashMap;
import java.util.Map;

public class TwilioRestClient
extends TwilioClient {
    private final Account authAccount = new Account(this);

    public TwilioRestClient(String accountSid, String authToken) {
        super(accountSid, authToken, "https://api.twilio.com");
        this.authAccount.setSid(accountSid);
        this.authAccount.setAuthToken(authToken);
    }

    public TwilioRestClient(String accountSid, String authToken, String endpoint) {
        super(accountSid, authToken, endpoint);
        this.authAccount.setSid(accountSid);
        this.authAccount.setAuthToken(authToken);
    }

    public AccountList getAccounts(Map<String, String> params) {
        AccountList list = new AccountList(this, params);
        list.setRequestAccountSid(this.getAccountSid());
        return list;
    }

    public AccountList getAccounts() {
        return this.getAccounts(new HashMap<String, String>());
    }

    public AccountFactory getAccountFactory() {
        return this.getAccounts();
    }

    public Account getAccount() {
        return this.authAccount;
    }

    public Account getAccount(String sid) {
        Account account = new Account(this);
        account.setSid(sid);
        account.setRequestAccountSid(sid);
        return account;
    }
}

