/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.taskrouter;

import com.twilio.sdk.CapabilityToken;
import com.twilio.sdk.taskrouter.FilterRequirement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class TaskRouterCapability
extends CapabilityToken {
    private static final String TASKROUTER_BASE_URL = "https://taskrouter.twilio.com";
    private static final String TASKROUTER_VERSION = "v1";
    private static final String TASKROUTER_EVENT_URL = "https://event-bridge.twilio.com/v1/wschannels";
    private String accountSid;
    private String authToken;
    private String workspaceSid;
    private String workerSid;
    private List<Policy> policies;

    public TaskRouterCapability(String accountSid, String authToken, String workspaceSid, String workerSid) {
        this.accountSid = accountSid;
        this.authToken = authToken;
        this.workspaceSid = workspaceSid;
        this.workerSid = workerSid;
        this.policies = new ArrayList<Policy>();
        this.addEventBridgePolicies();
        this.allowActivityListFetch();
    }

    public TaskRouterCapability allowWorkerActivityUpdates() {
        Policy update = new Policy(this.getWorkerUrl(), "POST", true).addPostFilterParam("ActivitySid", FilterRequirement.REQUIRED);
        return this.addPolicy(update);
    }

    public TaskRouterCapability allowWorkerFetchAttributes() {
        return this.addPolicy(new Policy(this.getWorkerUrl(), "GET", true));
    }

    public TaskRouterCapability allowTaskReservationUpdates() {
        String tasksUrl = this.getWorkspaceUrl() + "/Tasks/**";
        Policy update = new Policy(tasksUrl, "POST", true).addPostFilterParam("ReservationStatus", FilterRequirement.REQUIRED);
        return this.addPolicy(update);
    }

    public TaskRouterCapability addPolicy(Policy policy) {
        this.policies.add(policy);
        return this;
    }

    public String generateToken() throws CapabilityToken.DomainException {
        return this.generateToken(3600L);
    }

    public String generateToken(long ttl) throws CapabilityToken.DomainException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("iss", this.accountSid);
        payload.put("exp", System.currentTimeMillis() / 1000L + ttl);
        payload.put("version", TASKROUTER_VERSION);
        payload.put("account_sid", this.accountSid);
        payload.put("worker_sid", this.workerSid);
        payload.put("workspace_sid", this.workspaceSid);
        payload.put("channel", this.workerSid);
        payload.put("friendly_name", this.workerSid);
        payload.put("policies", this.policies);
        try {
            return TaskRouterCapability.jwtEncode(payload, this.authToken);
        }
        catch (Exception e) {
            throw new CapabilityToken.DomainException(e);
        }
    }

    private String getWorkspaceUrl() {
        return "https://taskrouter.twilio.com/v1/Workspaces/" + this.workspaceSid;
    }

    private String getWorkerUrl() {
        return this.getWorkspaceUrl() + "/Workers/" + this.workerSid;
    }

    private void addEventBridgePolicies() {
        String eventBridgeUrl = "https://event-bridge.twilio.com/v1/wschannels/" + this.accountSid + "/" + this.workerSid;
        this.addPolicy(new Policy(eventBridgeUrl, "GET", true));
        this.addPolicy(new Policy(eventBridgeUrl, "POST", true));
    }

    private void allowActivityListFetch() {
        String url = this.getWorkspaceUrl() + "/Activities";
        this.addPolicy(new Policy(url, "GET", true));
    }

    public class Policy
    implements JSONAware {
        private String url;
        private String method;
        private Map<String, FilterRequirement> queryFilter;
        private Map<String, FilterRequirement> postFilter;
        private boolean allowed;

        public Policy(String url, String method, Map<String, FilterRequirement> queryFilter, Map<String, FilterRequirement> postFilter, boolean allowed) {
            this.url = url;
            this.method = method;
            this.queryFilter = queryFilter;
            this.postFilter = postFilter;
            this.allowed = allowed;
        }

        public Policy(String url, String method, boolean allowed) {
            this.url = url;
            this.method = method;
            this.allowed = allowed;
            this.setQueryFilter(new HashMap<String, FilterRequirement>());
            this.setPostFilter(new HashMap<String, FilterRequirement>());
        }

        public Policy addQueryFilterParam(String name, FilterRequirement required) {
            this.queryFilter.put(name, required);
            return this;
        }

        public Policy addPostFilterParam(String name, FilterRequirement required) {
            this.postFilter.put(name, required);
            return this;
        }

        public Policy setQueryFilter(Map<String, FilterRequirement> queryFilter) {
            this.queryFilter = queryFilter;
            return this;
        }

        public Policy setPostFilter(Map<String, FilterRequirement> postFilter) {
            this.postFilter = postFilter;
            return this;
        }

        public String toJSONString() {
            JSONObject obj = new JSONObject();
            obj.put((Object)"url", (Object)this.url);
            obj.put((Object)"method", (Object)this.method);
            obj.put((Object)"allow", (Object)this.allowed);
            JSONObject query = new JSONObject();
            JSONObject post = new JSONObject();
            for (Map.Entry<String, FilterRequirement> e : this.queryFilter.entrySet()) {
                query.put((Object)e.getKey(), (Object)e.getValue());
            }
            for (Map.Entry<String, FilterRequirement> e : this.postFilter.entrySet()) {
                post.put((Object)e.getKey(), (Object)e.getValue());
            }
            obj.put((Object)"query_filter", (Object)query);
            obj.put((Object)"post_filter", (Object)post);
            return obj.toJSONString();
        }
    }
}

