/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list.sip;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.ListResource;
import com.twilio.sdk.resource.factory.sip.IpAccessControlListMappingFactory;
import com.twilio.sdk.resource.instance.sip.IpAccessControlListMapping;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class IpAccessControlListMappingList
extends ListResource<IpAccessControlListMapping>
implements IpAccessControlListMappingFactory {
    private String requestSipDomainSid;

    public IpAccessControlListMappingList(TwilioRestClient client) {
        super(client);
    }

    public IpAccessControlListMappingList(TwilioRestClient client, String sipDomainSid) {
        super(client);
        this.requestSipDomainSid = sipDomainSid;
    }

    public IpAccessControlListMappingList(TwilioRestClient client, Map<String, String> filters) {
        super(client, filters);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/SIP/Domains/" + this.getRequestSipDomainSid() + "/IpAccessControlListMappings.json";
    }

    @Override
    protected IpAccessControlListMapping makeNew(TwilioRestClient client, Map<String, Object> params) {
        return new IpAccessControlListMapping(client, params);
    }

    @Override
    protected String getListKey() {
        return "ip_access_control_list_mappings";
    }

    @Override
    public IpAccessControlListMapping create(Map<String, String> params) throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew(this.getClient(), (Map)response.toMap());
    }

    @Override
    public IpAccessControlListMapping create(List<NameValuePair> params) throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew(this.getClient(), (Map)response.toMap());
    }

    public String getRequestSipDomainSid() {
        return this.requestSipDomainSid;
    }
}

