/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.sip;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.factory.sip.CredentialFactory;
import com.twilio.sdk.resource.instance.sip.Credential;
import com.twilio.sdk.resource.list.sip.CredentialList;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class CredentialListInstance
extends InstanceResource {
    private static final String SID_PROPERTY = "sid";

    public CredentialListInstance(TwilioRestClient client) {
        super(client);
    }

    public CredentialListInstance(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a CredentialListInstance can not be null");
        }
        this.setProperty(SID_PROPERTY, sid);
    }

    public CredentialListInstance(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/SIP/CredentialLists/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty(SID_PROPERTY);
    }

    public Date getDateCreated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_created"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateUpdated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_updated"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getRealm() {
        return this.getProperty("realm");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public CredentialList getCredentials() {
        CredentialList credentials = new CredentialList(this.getClient(), this.getSid());
        credentials.setRequestAccountSid(this.getRequestAccountSid());
        return credentials;
    }

    public Credential getCredential(String credentialSid) {
        Credential credential = new Credential(this.getClient(), this.getSid(), credentialSid);
        credential.setRequestAccountSid(this.getRequestAccountSid());
        return credential;
    }

    public CredentialFactory getCredentialFactory() {
        return this.getCredentials();
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

