/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;

public class RethrowingForwarder {
    public static <T> T create(@Nullable T target, Class<? extends RuntimeException> exceptionClazz) {
        if (target == null) {
            return null;
        }
        Class<?>[] interfaces = RethrowingForwarder.getImplementedInterfaces(target);
        if (interfaces.length == 0) {
            throw new IllegalArgumentException("The target object must implement at least one interface");
        }
        return (T)Proxy.newProxyInstance(target.getClass().getClassLoader(), interfaces, (InvocationHandler)new RethrowingProxy(target, exceptionClazz));
    }

    private static Class<?>[] getImplementedInterfaces(Object implementation) {
        HashSet interfaces = new HashSet();
        for (Class<?> cls = implementation.getClass(); cls != null; cls = cls.getSuperclass()) {
            interfaces.addAll(Arrays.asList(cls.getInterfaces()));
        }
        return interfaces.toArray(new Class[0]);
    }

    private RethrowingForwarder() {
    }

    private static class RethrowingProxy
    implements InvocationHandler {
        private static final Method OBJECT_EQUALS;
        private static final Method OBJECT_HASHCODE;
        @NonNull
        private final Object mTarget;
        @NonNull
        private final Constructor<? extends RuntimeException> mExceptionConstructor;

        RethrowingProxy(@NonNull Object target, Class<? extends RuntimeException> exceptionClazz) {
            this.mTarget = target;
            try {
                this.mExceptionConstructor = exceptionClazz.getConstructor(Throwable.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Constructor " + exceptionClazz.getName() + "(Throwable) not found");
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (OBJECT_HASHCODE.equals(method)) {
                return this.mTarget.hashCode();
            }
            if (OBJECT_EQUALS.equals(method)) {
                return this.equalsInternal(proxy, args[0]);
            }
            try {
                return method.invoke(this.mTarget, args);
            }
            catch (InvocationTargetException e) {
                throw this.mExceptionConstructor.newInstance(e.getCause());
            }
        }

        private boolean equalsInternal(Object me, Object other) {
            if (other == null || other.getClass() != me.getClass()) {
                return false;
            }
            RethrowingProxy otherProxy = (RethrowingProxy)Proxy.getInvocationHandler(other);
            return otherProxy.mExceptionConstructor.equals(this.mExceptionConstructor) && otherProxy.mTarget.equals(this.mTarget);
        }

        static {
            try {
                OBJECT_EQUALS = Object.class.getMethod("equals", Object.class);
                OBJECT_HASHCODE = Object.class.getMethod("hashCode", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("never happens", e);
            }
        }
    }
}

