/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import com.twilio.conversations.AggregatedDeliveryReceipt;
import com.twilio.conversations.Attributes;
import com.twilio.conversations.CallbackListener;
import com.twilio.conversations.CancellationToken;
import com.twilio.conversations.Conversation;
import com.twilio.conversations.ConversationsClientImpl;
import com.twilio.conversations.DetailedDeliveryReceipt;
import com.twilio.conversations.Disposable;
import com.twilio.conversations.Media;
import com.twilio.conversations.MediaCategory;
import com.twilio.conversations.Message;
import com.twilio.conversations.MessageImpl;
import com.twilio.conversations.Participant;
import com.twilio.conversations.StatusListener;
import com.twilio.conversations.content.ContentData;
import com.twilio.conversations.content.ContentExtensionsKt;
import com.twilio.conversations.extensions.MediaClientExtensionsKt;
import com.twilio.conversations.internal.CallbackListenerForwarder;
import com.twilio.conversations.internal.DateUtils;
import com.twilio.conversations.internal.StatusListenerForwarder;
import com.twilio.conversations.media.MediaClient;
import com.twilio.util.ErrorInfo;
import com.twilio.util.ErrorReason;
import com.twilio.util.InternalUtilsKt;
import com.twilio.util.TwilioException;
import com.twilio.util.TwilioLogger;
import com.twilio.util.TwilioLoggerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001bB\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u0011\u0010\u0019\u001a\u00020\u001aH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\t\u0010#\u001a\u00020\u0017H\u0096 J\b\u0010$\u001a\u00020\u0017H\u0016J\u0016\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0(H\u0016J\n\u0010)\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0017H\u0016J\t\u0010-\u001a\u00020\u0017H\u0096 J\b\u0010.\u001a\u00020/H\u0016J\t\u00100\u001a\u00020\u0017H\u0096 J\b\u00101\u001a\u00020/H\u0016J\u001e\u00102\u001a\u00020\u00152\u0014\u0010'\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002030\u001f\u0018\u00010(H\u0016J\n\u00104\u001a\u0004\u0018\u00010 H\u0016J\u0012\u00104\u001a\u0004\u0018\u00010 2\u0006\u00105\u001a\u00020\u0017H\u0016J\n\u00106\u001a\u0004\u0018\u00010 H\u0016J\u0012\u00106\u001a\u0004\u0018\u00010 2\u0006\u00105\u001a\u00020\u0017H\u0016J\u000b\u00107\u001a\u0004\u0018\u00010\u0017H\u0096 J\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0016J\t\u0010<\u001a\u00020\u0004H\u0096 J\b\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020\u0017H\u0016J\t\u0010@\u001a\u00020\u0017H\u0096 J\n\u0010A\u001a\u0004\u0018\u00010\u0017H\u0016J\u001e\u0010B\u001a\u00020&2\u0006\u0010C\u001a\u00020\u00172\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170(H\u0002J\"\u0010D\u001a\u00020&2\u0018\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170E0(H\u0016J0\u0010F\u001a\u00020&2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0018\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170E0(H\u0016J0\u0010H\u001a\u00020&2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00170\u001f2\u0018\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170E0(H\u0016J\t\u0010J\u001a\u00020\u0015H\u0082 J\t\u0010K\u001a\u00020\u001dH\u0082 J\t\u0010L\u001a\u00020\u0017H\u0082 J\t\u0010M\u001a\u00020+H\u0082 J\t\u0010N\u001a\u00020\u0017H\u0082 J\u000b\u0010O\u001a\u0004\u0018\u00010\u0017H\u0082 J\t\u0010P\u001a\u00020QH\u0082 J\u001d\u0010R\u001a\u00020\u00152\u0012\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002030\u001f0(H\u0082 J\"\u0010S\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00170TH\u0082 \u00a2\u0006\u0002\u0010UJ\t\u0010V\u001a\u00020>H\u0082 J\t\u0010W\u001a\u00020\u0017H\u0082 J\t\u0010X\u001a\u00020\u0017H\u0082 J\u000b\u0010Y\u001a\u0004\u0018\u00010\u0017H\u0082 J\u0019\u0010Z\u001a\u00020\u00152\u0006\u0010[\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\\H\u0082 J\u001b\u0010]\u001a\u00020\u00152\b\u0010^\u001a\u0004\u0018\u00010\u00172\u0006\u0010'\u001a\u00020\\H\u0082 J\u001a\u0010_\u001a\u00020\u00152\u0006\u0010`\u001a\u00020\"2\b\u0010'\u001a\u0004\u0018\u00010\\H\u0016J\u001c\u0010a\u001a\u00020\u00152\b\u0010^\u001a\u0004\u0018\u00010\u00172\b\u0010'\u001a\u0004\u0018\u00010\\H\u0016R#\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006c"}, d2={"Lcom/twilio/conversations/MessageImpl;", "Lcom/twilio/conversations/Message;", "Lcom/twilio/conversations/Disposable;", "nativeHandle", "", "(J)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "kotlin.jvm.PlatformType", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "coroutineScope$delegate", "Lkotlin/Lazy;", "isDisposed", "", "mediaClient", "Lcom/twilio/conversations/media/MediaClient;", "getMediaClient", "()Lcom/twilio/conversations/media/MediaClient;", "mediaClient$delegate", "checkDisposed", "", "method", "", "dispose", "downloadContentData", "Lcom/twilio/conversations/content/ContentData;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAggregatedDeliveryReceipt", "Lcom/twilio/conversations/AggregatedDeliveryReceipt;", "getAttachedMedia", "", "Lcom/twilio/conversations/Media;", "getAttributes", "Lcom/twilio/conversations/Attributes;", "getAuthor", "getBody", "getContentData", "Lcom/twilio/conversations/CancellationToken;", "listener", "Lcom/twilio/conversations/CallbackListener;", "getContentSid", "getConversation", "Lcom/twilio/conversations/Conversation;", "getConversationSid", "getDateCreated", "getDateCreatedAsDate", "Ljava/util/Date;", "getDateUpdated", "getDateUpdatedAsDate", "getDetailedDeliveryReceiptList", "Lcom/twilio/conversations/DetailedDeliveryReceipt;", "getEmailBody", "contentType", "getEmailHistory", "getLastUpdatedBy", "getMediaByCategories", "categories", "", "Lcom/twilio/conversations/MediaCategory;", "getMessageIndex", "getParticipant", "Lcom/twilio/conversations/Participant;", "getParticipantSid", "getSid", "getSubject", "getTemporaryContentUrl", "mediaSid", "getTemporaryContentUrlsForAttachedMedia", "", "getTemporaryContentUrlsForMedia", "media", "getTemporaryContentUrlsForMediaSids", "mediaSids", "nativeDispose", "nativeGetAggregatedDelivery", "nativeGetAttributes", "nativeGetChannel", "nativeGetChannelSid", "nativeGetContentSid", "nativeGetConversationsClient", "Lcom/twilio/conversations/ConversationsClientImpl;", "nativeGetDetailedDeliveryReceiptList", "nativeGetMediaByCategories", "", "([Ljava/lang/String;)Ljava/util/List;", "nativeGetMember", "nativeGetMemberSid", "nativeGetMessageBody", "nativeGetSubject", "nativeUpdateAttributes", "attrString", "Lcom/twilio/conversations/StatusListener;", "nativeUpdateMessageBody", "body", "setAttributes", "attributes", "updateBody", "MediaImpl", "convo-android_release"})
@SourceDebugExtension(value={"SMAP\nMessageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageImpl.kt\ncom/twilio/conversations/MessageImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,268:1\n223#2,2:269\n1549#2:272\n1620#2,3:273\n288#2,2:278\n288#2,2:280\n96#3:271\n37#4,2:276\n*S KotlinDebug\n*F\n+ 1 MessageImpl.kt\ncom/twilio/conversations/MessageImpl\n*L\n112#1:269,2\n175#1:272\n175#1:273,3\n186#1:278,2\n194#1:280,2\n115#1:271\n175#1:276,2\n*E\n"})
public final class MessageImpl
implements Message,
Disposable {
    private long nativeHandle;
    private boolean isDisposed;
    @NotNull
    private final Lazy mediaClient$delegate;
    @NotNull
    private final Lazy coroutineScope$delegate;

    protected MessageImpl(long nativeHandle) {
        this.nativeHandle = nativeHandle;
        this.mediaClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MediaClient>(this){
            final /* synthetic */ MessageImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final MediaClient invoke() {
                return MessageImpl.access$nativeGetConversationsClient(this.this$0).getMediaClient();
            }
        }));
        this.coroutineScope$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CoroutineScope>(this){
            final /* synthetic */ MessageImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final CoroutineScope invoke() {
                return MessageImpl.access$nativeGetConversationsClient(this.this$0).getCoroutineScope();
            }
        }));
    }

    private final MediaClient getMediaClient() {
        Lazy lazy = this.mediaClient$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-mediaClient>(...)");
        return (MediaClient)object;
    }

    private final CoroutineScope getCoroutineScope() {
        Lazy lazy = this.coroutineScope$delegate;
        return (CoroutineScope)lazy.getValue();
    }

    @Override
    @NotNull
    public native String getSid();

    @Override
    @NotNull
    public native String getAuthor();

    @Override
    @Nullable
    public String getSubject() {
        this.checkDisposed("getSubject");
        return this.nativeGetSubject();
    }

    @Override
    @NotNull
    public native String getDateCreated();

    @Override
    @NotNull
    public Date getDateCreatedAsDate() {
        this.checkDisposed("getDateCreatedAsDate");
        Date date = DateUtils.parseIso8601DateTime(this.getDateCreated());
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"parseIso8601DateTime(dateCreated)");
        return date;
    }

    @Override
    @NotNull
    public native String getDateUpdated();

    @Override
    @NotNull
    public Date getDateUpdatedAsDate() {
        this.checkDisposed("getDateUpdatedAsDate");
        Date date = DateUtils.parseIso8601DateTime(this.getDateUpdated());
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"parseIso8601DateTime(dateUpdated)");
        return date;
    }

    @Override
    @Nullable
    public native String getLastUpdatedBy();

    @Override
    @NotNull
    public String getBody() {
        this.checkDisposed("getMessageBody");
        return this.nativeGetMessageBody();
    }

    @Override
    @Nullable
    public String getContentSid() {
        this.checkDisposed("getContentSid");
        return this.nativeGetContentSid();
    }

    @Override
    @NotNull
    public CancellationToken getContentData(@NotNull CallbackListener<ContentData> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        CallbackListenerForwarder<ContentData> listenerForwarder = new CallbackListenerForwarder<ContentData>(listener);
        CoroutineScope coroutineScope2 = this.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope2, (String)"coroutineScope");
        Job job2 = BuildersKt.launch$default((CoroutineScope)coroutineScope2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listenerForwarder, this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CallbackListenerForwarder<ContentData> $listenerForwarder;
            final /* synthetic */ MessageImpl this$0;
            {
                this.$listenerForwarder = $listenerForwarder;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var4_4 = $this$launch = (CoroutineScope)this.L$0;
                        var5_5 = this.this$0;
                        $i$a$-runCatching-MessageImpl$getContentData$job$1$result$1 = false;
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v0 = MessageImpl.access$downloadContentData((MessageImpl)var5_5, (Continuation)this);
                        ** if (v0 != var10_2) goto lbl16
lbl15:
                        // 1 sources

                        return var10_2;
lbl16:
                        // 1 sources

                        ** GOTO lbl24
                    }
                    case 1: {
                        $i$a$-runCatching-MessageImpl$getContentData$job$1$result$1 = false;
                        $this$launch = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            var6_9 = Result.constructor-impl((Object)((ContentData)v0));
                        }
                        catch (Throwable $i$a$-runCatching-MessageImpl$getContentData$job$1$result$1) {
                            var6_9 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-MessageImpl$getContentData$job$1$result$1));
                        }
                        result = var6_9;
                        var5_5 = result;
                        var6_9 = this.$listenerForwarder;
                        v1 = Result.exceptionOrNull-impl((Object)var5_5);
                        if (v1 == null) break;
                        t = v1;
                        $i$a$-getOrElse-MessageImpl$getContentData$job$1$contentData$1 = false;
                        this.L$0 = $this$launch;
                        this.L$1 = var6_9;
                        this.label = 2;
                        v2 = InternalUtilsKt.toTwilioException((Throwable)t, (ErrorReason)ErrorReason.ContentMediaDownloadError, (Continuation)this);
                        if (v2 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl49
                    }
                    case 2: {
                        $i$a$-getOrElse-MessageImpl$getContentData$job$1$contentData$1 = false;
                        var6_9 = (CallbackListenerForwarder)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl49:
                        // 2 sources

                        e = (TwilioException)v2;
                        TwilioLoggerKt.getLogger((Object)$this$launch).e("Error downloadJsonMedia", (Throwable)e);
                        var6_9.onError(e.getErrorInfo());
                        return Unit.INSTANCE;
                    }
                }
                contentData = (ContentData)var5_5;
                this.$listenerForwarder.onSuccess(contentData);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return () -> MessageImpl.getContentData$lambda$0(job2);
    }

    /*
     * Unable to fully structure code
     */
    private final Object downloadContentData(Continuation<? super ContentData> var1_1) {
        if (!(var1_1 instanceof downloadContentData.1)) ** GOTO lbl-1000
        var12_2 = var1_1;
        if ((var12_2.label & -2147483648) != 0) {
            var12_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ MessageImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MessageImpl.access$downloadContentData(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.getContentSid() == null) {
                    throw new TwilioException(new ErrorInfo(ErrorReason.NoContentSid, 0, 0, null, null, 30, null), null, 2, null);
                }
                twilioPrefix = "application/x-vnd.com.twilio.rich.";
                bodies = this.getMediaByCategories(SetsKt.setOf((Object)MediaCategory.BODY));
                $this$first$iv = bodies;
                $i$f$first = false;
                for (T element$iv : $this$first$iv) {
                    it = (Media)element$iv;
                    $i$a$-first-MessageImpl$downloadContentData$contentMedia$1 = false;
                    if (!StringsKt.startsWith$default((String)it.getContentType(), (String)twilioPrefix, (boolean)false, (int)2, null)) continue;
                    ** GOTO lbl24
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
lbl24:
                // 1 sources

                contentMedia = (Media)element$iv;
                $continuation.L$0 = twilioPrefix;
                $continuation.L$1 = contentMedia;
                $continuation.label = 1;
                v0 = this.getMediaClient().downloadJsonMediaAsText(contentMedia.getSid(), (Continuation<? super String>)$continuation);
                if (v0 == var13_4) {
                    return var13_4;
                }
                ** GOTO lbl37
            }
            case 1: {
                contentMedia = (Media)$continuation.L$1;
                twilioPrefix = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 2 sources

                mediaText = (String)v0;
                this_$iv = InternalUtilsKt.getJson();
                $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                mediaJson = (JsonObject)this_$iv.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), mediaText);
                contentJson = JsonElementKt.getJsonObject((JsonElement)((JsonElement)CollectionsKt.first((Iterable)mediaJson.values())));
                dataType = StringsKt.replace$default((String)StringsKt.removePrefix((String)contentMedia.getContentType(), (CharSequence)twilioPrefix), (char)'.', (char)'/', (boolean)false, (int)4, null);
                return ContentExtensionsKt.toContentData(contentJson, dataType);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void updateBody(@Nullable String body, @Nullable StatusListener listener) {
        this.checkDisposed("updateMessageBody");
        this.nativeUpdateMessageBody(body, new StatusListenerForwarder(listener));
    }

    @Override
    @NotNull
    public String getConversationSid() {
        this.checkDisposed("getConversationSid");
        return this.nativeGetChannelSid();
    }

    @Override
    @NotNull
    public Conversation getConversation() {
        this.checkDisposed("getConversation");
        return this.nativeGetChannel();
    }

    @Override
    @NotNull
    public String getParticipantSid() {
        this.checkDisposed("getParticipantSid");
        return this.nativeGetMemberSid();
    }

    @Override
    @NotNull
    public Participant getParticipant() {
        this.checkDisposed("getParticipant");
        return this.nativeGetMember();
    }

    @Override
    public native long getMessageIndex();

    @Override
    @NotNull
    public Attributes getAttributes() {
        Attributes attributes;
        this.checkDisposed("getAttributes");
        String attrString = this.nativeGetAttributes();
        try {
            Attributes attributes2 = Attributes.parse(attrString);
            Intrinsics.checkNotNullExpressionValue((Object)attributes2, (String)"{\n            Attributes\u2026rse(attrString)\n        }");
            attributes = attributes2;
        }
        catch (JSONException e) {
            TwilioLoggerKt.getLogger((Object)this).e("Unable to parse message attributes", (Throwable)e);
            Attributes attributes3 = Attributes.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)attributes3, (String)"{\n            logger.e(\"\u2026ributes.DEFAULT\n        }");
            attributes = attributes3;
        }
        return attributes;
    }

    @Override
    public void setAttributes(@NotNull Attributes attributes, @Nullable StatusListener listener) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.checkDisposed("setAttributes");
        this.nativeUpdateAttributes(String.valueOf(attributes), new StatusListenerForwarder(listener));
    }

    @Override
    @NotNull
    public AggregatedDeliveryReceipt getAggregatedDeliveryReceipt() {
        this.checkDisposed("getAggregatedDeliveryReceipt");
        return this.nativeGetAggregatedDelivery();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Media> getMediaByCategories(@NotNull Set<? extends MediaCategory> categories) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        this.checkDisposed("getMediaByCategories");
        Iterable $this$map$iv = categories;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MediaCategory mediaCategory = (MediaCategory)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] categoryArray = thisCollection$iv.toArray(new String[0]);
        return this.nativeGetMediaByCategories(categoryArray);
    }

    @Override
    @NotNull
    public List<Media> getAttachedMedia() {
        return this.getMediaByCategories(SetsKt.setOf((Object)((Object)MediaCategory.MEDIA)));
    }

    @Override
    @Nullable
    public Media getEmailBody() {
        return this.getEmailBody("text/plain");
    }

    @Override
    @Nullable
    public Media getEmailBody(@NotNull String contentType) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            if (!this.getConversation().getLimits().getEmailBodiesAllowedContentTypes().contains(contentType)) {
                return null;
            }
            Iterable $this$firstOrNull$iv = this.getMediaByCategories(SetsKt.setOf((Object)((Object)MediaCategory.BODY)));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Media it = (Media)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getContentType(), (Object)contentType)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @Nullable
    public Media getEmailHistory() {
        return this.getEmailHistory("text/plain");
    }

    @Override
    @Nullable
    public Media getEmailHistory(@NotNull String contentType) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            if (!this.getConversation().getLimits().getEmailHistoriesAllowedContentTypes().contains(contentType)) {
                return null;
            }
            Iterable $this$firstOrNull$iv = this.getMediaByCategories(SetsKt.setOf((Object)((Object)MediaCategory.HISTORY)));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Media it = (Media)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getContentType(), (Object)contentType)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @NotNull
    public CancellationToken getTemporaryContentUrlsForAttachedMedia(@NotNull CallbackListener<Map<String, String>> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.getTemporaryContentUrlsForMedia((List<? extends Media>)this.getAttachedMedia(), listener);
    }

    @NotNull
    public CancellationToken getTemporaryContentUrlsForMedia(@NotNull List<? extends Media> media, @NotNull CallbackListener<Map<String, String>> listener) {
        Intrinsics.checkNotNullParameter(media, (String)"media");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        MediaClient mediaClient2 = this.getMediaClient();
        CoroutineScope coroutineScope2 = this.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope2, (String)"coroutineScope");
        return MediaClientExtensionsKt.getTemporaryContentUrlsForMedia(mediaClient2, coroutineScope2, media, listener);
    }

    @Override
    @NotNull
    public CancellationToken getTemporaryContentUrlsForMediaSids(@NotNull List<String> mediaSids, @NotNull CallbackListener<Map<String, String>> listener) {
        Intrinsics.checkNotNullParameter(mediaSids, (String)"mediaSids");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        MediaClient mediaClient2 = this.getMediaClient();
        CoroutineScope coroutineScope2 = this.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope2, (String)"coroutineScope");
        return MediaClientExtensionsKt.getTemporaryContentUrlsForMediaSids(mediaClient2, coroutineScope2, mediaSids, listener);
    }

    @Override
    public void getDetailedDeliveryReceiptList(@Nullable CallbackListener<List<DetailedDeliveryReceipt>> listener) {
        this.checkDisposed("getDetailedDeliveryReceiptList");
        this.nativeGetDetailedDeliveryReceiptList((CallbackListener<List<DetailedDeliveryReceipt>>)new CallbackListenerForwarder<List<DetailedDeliveryReceipt>>(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        MessageImpl messageImpl = this;
        synchronized (messageImpl) {
            boolean bl = false;
            this.checkDisposed("dispose");
            if (!this.isDisposed) {
                this.nativeDispose();
            }
            this.nativeHandle = 0L;
            this.isDisposed = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final CancellationToken getTemporaryContentUrl(String mediaSid, CallbackListener<String> listener) {
        CallbackListenerForwarder<String> listenerForwarder = new CallbackListenerForwarder<String>(listener);
        CoroutineScope coroutineScope2 = this.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope2, (String)"coroutineScope");
        Job job2 = BuildersKt.launch$default((CoroutineScope)coroutineScope2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listenerForwarder, this, mediaSid, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CallbackListenerForwarder<String> $listenerForwarder;
            final /* synthetic */ MessageImpl this$0;
            final /* synthetic */ String $mediaSid;
            {
                this.$listenerForwarder = $listenerForwarder;
                this.this$0 = $receiver;
                this.$mediaSid = $mediaSid;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var4_4 = $this$launch = (CoroutineScope)this.L$0;
                        var5_5 = this.this$0;
                        var6_6 = this.$mediaSid;
                        $i$a$-runCatching-MessageImpl$getTemporaryContentUrl$job$1$result$1 = false;
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v0 = MessageImpl.access$getMediaClient((MessageImpl)var5_5).getTemporaryContentUrl(var6_6, (Continuation<? super String>)this);
                        ** if (v0 != var11_2) goto lbl17
lbl16:
                        // 1 sources

                        return var11_2;
lbl17:
                        // 1 sources

                        ** GOTO lbl25
                    }
                    case 1: {
                        $i$a$-runCatching-MessageImpl$getTemporaryContentUrl$job$1$result$1 = false;
                        $this$launch = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            var7_10 = Result.constructor-impl((Object)((String)v0));
                        }
                        catch (Throwable $i$a$-runCatching-MessageImpl$getTemporaryContentUrl$job$1$result$1) {
                            var7_10 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-MessageImpl$getTemporaryContentUrl$job$1$result$1));
                        }
                        result = var7_10;
                        var5_5 = result;
                        var6_6 = this.$mediaSid;
                        var7_10 = this.$listenerForwarder;
                        v1 = Result.exceptionOrNull-impl((Object)var5_5);
                        if (v1 == null) break;
                        t = v1;
                        $i$a$-getOrElse-MessageImpl$getTemporaryContentUrl$job$1$url$1 = false;
                        this.L$0 = $this$launch;
                        this.L$1 = var6_6;
                        this.L$2 = var7_10;
                        this.label = 2;
                        v2 = InternalUtilsKt.toTwilioException((Throwable)t, (ErrorReason)ErrorReason.MediaFetchError, (Continuation)this);
                        if (v2 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl53
                    }
                    case 2: {
                        $i$a$-getOrElse-MessageImpl$getTemporaryContentUrl$job$1$url$1 = false;
                        var7_10 = (CallbackListenerForwarder)this.L$2;
                        var6_6 = (String)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl53:
                        // 2 sources

                        e = (TwilioException)v2;
                        TwilioLoggerKt.getLogger((Object)$this$launch).e("Error getting temporary url for media: " + var6_6, (Throwable)e);
                        var7_10.onError(e.getErrorInfo());
                        return Unit.INSTANCE;
                    }
                }
                url = (String)var5_5;
                this.$listenerForwarder.onSuccess(url);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return () -> MessageImpl.getTemporaryContentUrl$lambda$6(job2);
    }

    private final void checkDisposed(String method) {
        if (this.isDisposed) {
            TwilioLogger.e$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)this), (String)("Attempt to use disposed object in Message#" + method), null, (int)2, null);
        }
    }

    private final native ConversationsClientImpl nativeGetConversationsClient();

    private final native String nativeGetChannelSid();

    private final native Conversation nativeGetChannel();

    private final native String nativeGetMemberSid();

    private final native Participant nativeGetMember();

    private final native String nativeGetSubject();

    private final native String nativeGetContentSid();

    private final native String nativeGetMessageBody();

    private final native void nativeUpdateMessageBody(String var1, StatusListener var2);

    private final native void nativeUpdateAttributes(String var1, StatusListener var2);

    private final native String nativeGetAttributes();

    private final native AggregatedDeliveryReceipt nativeGetAggregatedDelivery();

    private final native void nativeGetDetailedDeliveryReceiptList(CallbackListener<List<DetailedDeliveryReceipt>> var1);

    private final native List<Media> nativeGetMediaByCategories(String[] var1);

    private final native void nativeDispose();

    private static final void getContentData$lambda$0(Job $job) {
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        Job.DefaultImpls.cancel$default((Job)$job, null, (int)1, null);
    }

    private static final void getTemporaryContentUrl$lambda$6(Job $job) {
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        Job.DefaultImpls.cancel$default((Job)$job, null, (int)1, null);
    }

    public static final /* synthetic */ Object access$downloadContentData(MessageImpl $this, Continuation $completion) {
        return $this.downloadContentData((Continuation<? super ContentData>)$completion);
    }

    public static final /* synthetic */ MediaClient access$getMediaClient(MessageImpl $this) {
        return $this.getMediaClient();
    }

    public static final /* synthetic */ ConversationsClientImpl access$nativeGetConversationsClient(MessageImpl $this) {
        return $this.nativeGetConversationsClient();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0016R\u0014\u0010\u0007\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lcom/twilio/conversations/MessageImpl$MediaImpl;", "Lcom/twilio/conversations/Media;", "message", "Lcom/twilio/conversations/MessageImpl;", "sid", "", "contentType", "category", "filename", "size", "", "(Lcom/twilio/conversations/MessageImpl;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;J)V", "Lcom/twilio/conversations/MediaCategory;", "getCategory", "()Lcom/twilio/conversations/MediaCategory;", "getContentType", "()Ljava/lang/String;", "getFilename", "getSid", "getSize", "()J", "getTemporaryContentUrl", "Lcom/twilio/conversations/CancellationToken;", "listener", "Lcom/twilio/conversations/CallbackListener;", "convo-android_release"})
    private static final class MediaImpl
    implements Media {
        @NotNull
        private final MessageImpl message;
        @NotNull
        private final String sid;
        @NotNull
        private final String contentType;
        @Nullable
        private final String filename;
        private final long size;
        @NotNull
        private final MediaCategory category;

        public MediaImpl(@NotNull MessageImpl message, @NotNull String sid, @NotNull String contentType, @NotNull String category, @Nullable String filename, long size) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)sid, (String)"sid");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            this.message = message;
            this.sid = sid;
            this.contentType = contentType;
            this.filename = filename;
            this.size = size;
            this.category = MediaCategory.Companion.fromString(category);
        }

        @Override
        @NotNull
        public String getSid() {
            return this.sid;
        }

        @Override
        @NotNull
        public String getContentType() {
            return this.contentType;
        }

        @Override
        @Nullable
        public String getFilename() {
            return this.filename;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        @NotNull
        public MediaCategory getCategory() {
            return this.category;
        }

        @Override
        @NotNull
        public CancellationToken getTemporaryContentUrl(@NotNull CallbackListener<String> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            return this.message.getTemporaryContentUrl(this.getSid(), listener);
        }
    }
}

