/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.wired;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.twilio.audioswitch.android.Logger;
import com.twilio.audioswitch.wired.WiredDeviceConnectionListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;", "Landroid/content/BroadcastReceiver;", "context", "Landroid/content/Context;", "logger", "Lcom/twilio/audioswitch/android/Logger;", "(Landroid/content/Context;Lcom/twilio/audioswitch/android/Logger;)V", "deviceListener", "Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "getDeviceListener$audioswitch_release", "()Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "setDeviceListener$audioswitch_release", "(Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;)V", "onReceive", "", "intent", "Landroid/content/Intent;", "start", "stop", "audioswitch_release"})
public final class WiredHeadsetReceiver
extends BroadcastReceiver {
    @NotNull
    private final Context context;
    @NotNull
    private final Logger logger;
    @Nullable
    private WiredDeviceConnectionListener deviceListener;

    public WiredHeadsetReceiver(@NotNull Context context, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.context = context;
        this.logger = logger;
    }

    @Nullable
    public final WiredDeviceConnectionListener getDeviceListener$audioswitch_release() {
        return this.deviceListener;
    }

    public final void setDeviceListener$audioswitch_release(@Nullable WiredDeviceConnectionListener wiredDeviceConnectionListener2) {
        this.deviceListener = wiredDeviceConnectionListener2;
    }

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                int state = intent.getIntExtra("state", 0);
                boolean bl = false;
                if (state != 1) break block2;
                String name = intent.getStringExtra("name");
                boolean bl2 = false;
                String string = name;
                if (string == null) {
                    string = "";
                }
                this.logger.d("WiredHeadsetReceiver", "Wired headset device " + string + " connected");
                WiredDeviceConnectionListener wiredDeviceConnectionListener2 = this.deviceListener;
                if (wiredDeviceConnectionListener2 == null) break block3;
                wiredDeviceConnectionListener2.onDeviceConnected();
                break block3;
            }
            String name = intent.getStringExtra("name");
            boolean bl = false;
            String string = name;
            if (string == null) {
                string = "";
            }
            this.logger.d("WiredHeadsetReceiver", "Wired headset device " + string + " disconnected");
            WiredDeviceConnectionListener wiredDeviceConnectionListener3 = this.deviceListener;
            if (wiredDeviceConnectionListener3 == null) break block3;
            wiredDeviceConnectionListener3.onDeviceDisconnected();
        }
    }

    public final void start(@NotNull WiredDeviceConnectionListener deviceListener) {
        Intrinsics.checkNotNullParameter((Object)deviceListener, (String)"deviceListener");
        this.deviceListener = deviceListener;
        this.context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.intent.action.HEADSET_PLUG"));
    }

    public final void stop() {
        this.deviceListener = null;
        this.context.unregisterReceiver((BroadcastReceiver)this);
    }
}

