/*
 * Decompiled with CFR 0.152.
 */
package com.tuyenmonkey.mkloader.type;

import android.graphics.Canvas;
import android.graphics.PointF;
import com.tuyenmonkey.mkloader.callback.InvalidateListener;

public abstract class LoaderView {
    protected int color;
    protected int width;
    protected int height;
    protected int desiredWidth = 150;
    protected int desiredHeight = 150;
    protected PointF center;
    protected InvalidateListener invalidateListener;

    public void setColor(int color) {
        this.color = color;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.center = new PointF((float)width / 2.0f, (float)height / 2.0f);
    }

    public void setInvalidateListener(InvalidateListener invalidateListener) {
        this.invalidateListener = invalidateListener;
    }

    public int getDesiredWidth() {
        return this.desiredWidth;
    }

    public int getDesiredHeight() {
        return this.desiredHeight;
    }

    public abstract void initializeObjects();

    public abstract void setUpAnimation();

    public abstract void draw(Canvas var1);

    public boolean isDetached() {
        return this.invalidateListener == null;
    }

    public void onDetach() {
        if (this.invalidateListener != null) {
            this.invalidateListener = null;
        }
    }
}

