/*
 * Decompiled with CFR 0.152.
 */
package com.tuyenmonkey.mkloader.type;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import com.tuyenmonkey.mkloader.model.Circle;
import com.tuyenmonkey.mkloader.type.LoaderView;

public class TwinFishesSpinner
extends LoaderView {
    private Circle[] circles;
    private int numberOfCircle = 10;
    private float[] rotates = new float[this.numberOfCircle];

    @Override
    public void initializeObjects() {
        int i;
        float size = Math.min(this.width, this.height);
        float circleRadius = size / 10.0f;
        this.circles = new Circle[this.numberOfCircle];
        for (i = 0; i < this.numberOfCircle / 2; ++i) {
            this.circles[i] = new Circle();
            this.circles[i].setCenter(this.center.x, circleRadius);
            this.circles[i].setColor(this.color);
            this.circles[i].setRadius(circleRadius - circleRadius * (float)i / 6.0f);
        }
        for (i = this.numberOfCircle / 2; i < this.numberOfCircle; ++i) {
            this.circles[i] = new Circle();
            this.circles[i].setCenter(this.center.x, size - circleRadius);
            this.circles[i].setColor(this.color);
            this.circles[i].setRadius(circleRadius - circleRadius * (float)(i - 5) / 6.0f);
        }
    }

    @Override
    public void setUpAnimation() {
        for (int i = 0; i < this.numberOfCircle; ++i) {
            final int index = i;
            ValueAnimator fadeAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
            fadeAnimator.setRepeatCount(-1);
            fadeAnimator.setDuration(1700L);
            fadeAnimator.setStartDelay((long)((index >= 5 ? index - 5 : index) * 100));
            fadeAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((TwinFishesSpinner)TwinFishesSpinner.this).rotates[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    if (TwinFishesSpinner.this.invalidateListener != null) {
                        TwinFishesSpinner.this.invalidateListener.reDraw();
                    }
                }
            });
            fadeAnimator.start();
        }
    }

    @Override
    public void draw(Canvas canvas) {
        for (int i = 0; i < this.numberOfCircle; ++i) {
            canvas.save();
            canvas.rotate(this.rotates[i], this.center.x, this.center.y);
            this.circles[i].draw(canvas);
            canvas.restore();
        }
    }
}

