/*
 * Decompiled with CFR 0.152.
 */
package com.turbomanage.httpclient;

import com.turbomanage.httpclient.ConsoleRequestLogger;
import com.turbomanage.httpclient.HttpMethod;
import com.turbomanage.httpclient.HttpRequestException;
import com.turbomanage.httpclient.HttpResponse;
import com.turbomanage.httpclient.RequestHandler;
import com.turbomanage.httpclient.RequestLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public abstract class BasicRequestHandler
implements RequestHandler {
    private final RequestLogger logger;

    public BasicRequestHandler() {
        this(new ConsoleRequestLogger());
    }

    public BasicRequestHandler(RequestLogger logger) {
        this.logger = logger;
    }

    @Override
    public HttpURLConnection openConnection(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        return uc;
    }

    @Override
    public void prepareConnection(HttpURLConnection urlConnection, HttpMethod httpMethod, String contentType) throws IOException {
        urlConnection.setRequestMethod(httpMethod.getMethodName());
        urlConnection.setDoOutput(httpMethod.getDoOutput());
        urlConnection.setDoInput(httpMethod.getDoInput());
        if (contentType != null) {
            urlConnection.setRequestProperty("Content-Type", contentType);
        }
        urlConnection.setRequestProperty("Accept-Charset", "UTF-8");
    }

    @Override
    public OutputStream openOutput(HttpURLConnection urlConnection) throws IOException {
        return urlConnection.getOutputStream();
    }

    @Override
    public void writeStream(OutputStream out, byte[] content) throws IOException {
        out.write(content);
    }

    @Override
    public InputStream openInput(HttpURLConnection urlConnection) throws IOException {
        return urlConnection.getInputStream();
    }

    @Override
    public byte[] readStream(InputStream in) throws IOException {
        int nRead;
        byte[] data = new byte[16384];
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while ((nRead = in.read(data)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    @Override
    public boolean onError(HttpRequestException e) {
        int status;
        HttpResponse res = e.getHttpResponse();
        if (this.logger.isLoggingEnabled()) {
            this.logger.log("BasicRequestHandler.onError got");
            e.printStackTrace();
        }
        return res != null && (status = res.getStatus()) > 0;
    }
}

