/*
 * Decompiled with CFR 0.152.
 */
package com.tupilabs.human_name_parser;

import com.tupilabs.human_name_parser.HumanNameParserParser;
import com.tupilabs.human_name_parser.Name;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class HumanNameParserBuilder {
    public static final List<String> DEFAULT_SALUTATIONS = Collections.unmodifiableList(Arrays.asList("mr", "master", "mister", "mrs", "miss", "ms", "dr", "prof", "rev", "fr", "judge", "honorable", "hon"));
    public static final List<String> DEFAULT_POSTNOMINALS = Collections.unmodifiableList(Arrays.asList("phd", "ph.d.", "ph.d", "esq", "esquire", "apr", "rph", "pe", "md", "ma", "dmd", "cme", "dds", "cpa", "dvm"));
    public static final List<String> DEFAULT_PREFIXES = Collections.unmodifiableList(Arrays.asList("bar", "ben", "bin", "da", "dal", "de la", "de", "del", "der", "di", "ibn", "la", "le", "san", "st", "ste", "van", "van der", "van den", "vel", "von"));
    public static final List<String> DEFAULT_SUFFIXES = Collections.unmodifiableList(Arrays.asList("jr", "sr", "2", "ii", "iii", "iv", "v", "senior", "junior"));
    private Name name;
    private List<String> salutations;
    private List<String> postnominals;
    private List<String> prefixes;
    private List<String> suffixes;

    public HumanNameParserBuilder(String name) {
        Objects.requireNonNull(name);
        this.name = new Name(name);
    }

    public HumanNameParserBuilder(Name name) {
        Objects.requireNonNull(name);
        this.name = name;
    }

    public HumanNameParserParser build() {
        if (this.salutations == null) {
            this.salutations = DEFAULT_SALUTATIONS;
        }
        if (this.postnominals == null) {
            this.postnominals = DEFAULT_POSTNOMINALS;
        }
        if (this.prefixes == null) {
            this.prefixes = DEFAULT_PREFIXES;
        }
        if (this.suffixes == null) {
            this.suffixes = DEFAULT_SUFFIXES;
        }
        HumanNameParserParser parser = new HumanNameParserParser(this.name, this.salutations, this.postnominals, this.prefixes, this.suffixes);
        parser.parse();
        return parser;
    }

    public HumanNameParserBuilder withSalutations(List<String> salutations) {
        Objects.requireNonNull(salutations);
        this.salutations = salutations;
        return this;
    }

    public HumanNameParserBuilder withExtraSalutations(List<String> salutations) {
        Objects.requireNonNull(salutations);
        this.salutations = new ArrayList<String>(salutations);
        this.salutations.addAll(DEFAULT_SALUTATIONS);
        return this;
    }

    public HumanNameParserBuilder withPostnominals(List<String> postnominals) {
        Objects.requireNonNull(postnominals);
        this.postnominals = postnominals;
        return this;
    }

    public HumanNameParserBuilder withExtraPostnominals(List<String> postnominals) {
        Objects.requireNonNull(postnominals);
        this.postnominals = new ArrayList<String>(postnominals);
        this.postnominals.addAll(DEFAULT_POSTNOMINALS);
        return this;
    }

    public HumanNameParserBuilder withPrefixes(List<String> prefixes) {
        Objects.requireNonNull(prefixes);
        this.prefixes = prefixes;
        return this;
    }

    public HumanNameParserBuilder withExtraPrefixes(List<String> prefixes) {
        Objects.requireNonNull(prefixes);
        this.prefixes = new ArrayList<String>(prefixes);
        this.prefixes.addAll(DEFAULT_PREFIXES);
        return this;
    }

    public HumanNameParserBuilder withSuffixes(List<String> suffixes) {
        Objects.requireNonNull(suffixes);
        this.suffixes = suffixes;
        return this;
    }

    public HumanNameParserBuilder withExtraSuffixes(List<String> suffixes) {
        Objects.requireNonNull(suffixes);
        this.suffixes = new ArrayList<String>(suffixes);
        this.suffixes.addAll(DEFAULT_SUFFIXES);
        return this;
    }
}

