/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.dfa;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.dfa.DFASerializer;
import org.antlr.v4.runtime.dfa.DFAState;
import org.antlr.v4.runtime.dfa.LexerDFASerializer;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;

public class DFA {
    @NotNull
    public final ConcurrentMap<DFAState, DFAState> states = new ConcurrentHashMap<DFAState, DFAState>();
    @NotNull
    public final AtomicReference<DFAState> s0 = new AtomicReference();
    @NotNull
    public final AtomicReference<DFAState> s0full = new AtomicReference();
    public final int decision;
    @NotNull
    public final ATNState atnStartState;
    private final AtomicInteger nextStateNumber = new AtomicInteger();
    private volatile boolean precedenceDfa;

    public DFA(@NotNull ATNState atnStartState) {
        this(atnStartState, 0);
    }

    public DFA(@NotNull ATNState atnStartState, int decision) {
        this.atnStartState = atnStartState;
        this.decision = decision;
    }

    public final boolean isPrecedenceDfa() {
        return this.precedenceDfa;
    }

    public final DFAState getPrecedenceStartState(int precedence, boolean fullContext) {
        if (!this.isPrecedenceDfa()) {
            throw new IllegalStateException("Only precedence DFAs may contain a precedence start state.");
        }
        if (fullContext) {
            return this.s0full.get().getTarget(precedence);
        }
        return this.s0.get().getTarget(precedence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPrecedenceStartState(int precedence, boolean fullContext, DFAState startState) {
        if (!this.isPrecedenceDfa()) {
            throw new IllegalStateException("Only precedence DFAs may contain a precedence start state.");
        }
        if (precedence < 0) {
            return;
        }
        if (fullContext) {
            AtomicReference<DFAState> atomicReference = this.s0full;
            synchronized (atomicReference) {
                this.s0full.get().setTarget(precedence, startState);
            }
        }
        AtomicReference<DFAState> atomicReference = this.s0;
        synchronized (atomicReference) {
            this.s0.get().setTarget(precedence, startState);
        }
    }

    public final synchronized void setPrecedenceDfa(boolean precedenceDfa) {
        if (this.precedenceDfa != precedenceDfa) {
            this.states.clear();
            if (precedenceDfa) {
                DFAState precedenceState = new DFAState(new ATNConfigSet(), 0, 200);
                precedenceState.isAcceptState = false;
                this.s0.set(precedenceState);
                DFAState fullContextPrecedenceState = new DFAState(new ATNConfigSet(), 0, 200);
                fullContextPrecedenceState.isAcceptState = false;
                this.s0full.set(fullContextPrecedenceState);
            } else {
                this.s0.set(null);
                this.s0full.set(null);
            }
            this.precedenceDfa = precedenceDfa;
        }
    }

    public boolean isEmpty() {
        if (this.isPrecedenceDfa()) {
            return this.s0.get().getEdgeMap().isEmpty() && this.s0full.get().getEdgeMap().isEmpty();
        }
        return this.s0.get() == null && this.s0full.get() == null;
    }

    public boolean isContextSensitive() {
        if (this.isPrecedenceDfa()) {
            return !this.s0full.get().getEdgeMap().isEmpty();
        }
        return this.s0full.get() != null;
    }

    public DFAState addState(DFAState state) {
        state.stateNumber = this.nextStateNumber.getAndIncrement();
        DFAState existing = this.states.putIfAbsent(state, state);
        if (existing != null) {
            return existing;
        }
        return state;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(@Nullable String[] tokenNames) {
        if (this.s0.get() == null) {
            return "";
        }
        DFASerializer serializer = new DFASerializer(this, tokenNames);
        return serializer.toString();
    }

    public String toString(@Nullable String[] tokenNames, @Nullable String[] ruleNames) {
        if (this.s0.get() == null) {
            return "";
        }
        DFASerializer serializer = new DFASerializer(this, tokenNames, ruleNames, this.atnStartState.atn);
        return serializer.toString();
    }

    public String toLexerString() {
        if (this.s0.get() == null) {
            return "";
        }
        LexerDFASerializer serializer = new LexerDFASerializer(this);
        return serializer.toString();
    }
}

