/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidx.material.animator;

import android.content.Context;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import com.google.android.material.button.MaterialButton;
import com.tunjid.androidx.core.content.ContextExtensionsKt;
import com.tunjid.androidx.core.graphics.drawable.DrawableExtensionsKt;
import com.tunjid.androidx.material.R;
import com.tunjid.androidx.material.animator.ScaleProperty;
import com.tunjid.androidx.material.animator.SpringSizeInterpolator;
import com.tunjid.androidx.material.animator.StrokeWidthProperty;
import com.tunjid.androidx.view.util.ViewExtensionsKt;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0002,-B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u001f\u0010\u001e\u001a\u00020\u001b2\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001b0 \u00a2\u0006\u0002\b!J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000bH\u0016J\u000e\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\tJ\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\b\b\u0001\u0010*\u001a\u00020\u0005J\u001a\u0010%\u001a\u00020\u001b2\b\b\u0001\u0010+\u001a\u00020\u00052\b\b\u0001\u0010*\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\u00020\u000b8F\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0010\u0010\rR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/tunjid/androidx/material/animator/FabExtensionAnimator;", "", "button", "Lcom/google/android/material/button/MaterialButton;", "collapsedFabSize", "", "expandedFabHeight", "(Lcom/google/android/material/button/MaterialButton;II)V", "glyphState", "Lcom/tunjid/androidx/material/animator/FabExtensionAnimator$GlyphState;", "extended", "", "isExtended", "()Z", "setExtended", "(Z)V", "isRunning", "isRunning$annotations", "()V", "scaleAnimation", "Landroidx/dynamicanimation/animation/SpringAnimation;", "sizeInterpolator", "Lcom/tunjid/androidx/material/animator/SpringSizeInterpolator;", "strokeAnimation", "strokeWidth", "", "animateChange", "", "newGlyphState", "oldGlyphState", "configureSpring", "options", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "runCollapsedAnimations", "iconSame", "textSame", "updateGlyphs", "text", "", "drawable", "Landroid/graphics/drawable/Drawable;", "drawableRes", "stringRes", "GlyphState", "SimpleGlyphState", "com.tunjid.androidx.material"})
public class FabExtensionAnimator {
    private final float strokeWidth;
    private GlyphState glyphState;
    private final SpringSizeInterpolator sizeInterpolator;
    private final SpringAnimation strokeAnimation;
    private final SpringAnimation scaleAnimation;
    private boolean isExtended;
    private final MaterialButton button;

    public static /* synthetic */ void isRunning$annotations() {
    }

    public final boolean isRunning() {
        return this.sizeInterpolator.isRunning();
    }

    public final boolean isExtended() {
        return this.isExtended;
    }

    public final void setExtended(boolean extended) {
        this.isExtended = extended;
        this.sizeInterpolator.run(extended);
    }

    public final void configureSpring(@NotNull Function1<? super SpringAnimation, Unit> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.sizeInterpolator.attachToSpring(options);
        SpringAnimation springAnimation = this.strokeAnimation;
        boolean bl = false;
        boolean bl2 = false;
        options.invoke((Object)springAnimation);
        springAnimation = this.scaleAnimation;
        bl = false;
        bl2 = false;
        options.invoke((Object)springAnimation);
    }

    public final void updateGlyphs(@StringRes int stringRes, @DrawableRes int drawableRes) {
        Context context = this.button.getContext();
        boolean bl = false;
        boolean bl2 = false;
        Context $this$run = context;
        boolean bl3 = false;
        CharSequence charSequence = $this$run.getText(stringRes);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getText(stringRes)");
        Context context2 = $this$run;
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"this");
        this.updateGlyphs(new SimpleGlyphState(charSequence, ContextExtensionsKt.drawableAt((Context)context2, (int)drawableRes)));
    }

    public final void updateGlyphs(@NotNull CharSequence text, @DrawableRes int drawableRes) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Context context = this.button.getContext();
        boolean bl = false;
        boolean bl2 = false;
        Context $this$run = context;
        boolean bl3 = false;
        this.updateGlyphs(new SimpleGlyphState(text, ContextExtensionsKt.drawableAt((Context)$this$run, (int)drawableRes)));
    }

    public final void updateGlyphs(@NotNull CharSequence text, @Nullable Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Context context = this.button.getContext();
        boolean bl = false;
        boolean bl2 = false;
        Context $this$run = context;
        boolean bl3 = false;
        this.updateGlyphs(new SimpleGlyphState(text, drawable));
    }

    public final void updateGlyphs(@NotNull GlyphState newGlyphState) {
        Intrinsics.checkNotNullParameter((Object)newGlyphState, (String)"newGlyphState");
        GlyphState oldGlyphState = this.glyphState;
        this.glyphState = newGlyphState;
        this.animateChange(newGlyphState, oldGlyphState);
    }

    private final void animateChange(GlyphState newGlyphState, GlyphState oldGlyphState) {
        this.button.setText(newGlyphState.getText());
        this.button.setIcon(newGlyphState.getIcon());
        this.sizeInterpolator.run(this.isExtended);
        if (!this.isExtended) {
            this.runCollapsedAnimations(DrawableExtensionsKt.sameAs((Drawable)newGlyphState.getIcon(), (Drawable)oldGlyphState.getIcon()), Intrinsics.areEqual((Object)newGlyphState.getText(), (Object)oldGlyphState.getText()));
        }
    }

    public void runCollapsedAnimations(boolean iconSame, boolean textSame) {
        if (iconSame && !this.scaleAnimation.isRunning()) {
            SpringAnimation springAnimation = this.strokeAnimation;
            boolean bl = false;
            boolean bl2 = false;
            SpringAnimation $this$apply = springAnimation;
            boolean bl3 = false;
            ViewExtensionsKt.withOneShotEndListener((SpringAnimation)$this$apply, (Function0)((Function0)new Function0<Unit>($this$apply){
                final /* synthetic */ SpringAnimation $this_apply;

                public final void invoke() {
                    this.$this_apply.animateToFinalPosition(0.0f);
                }
                {
                    this.$this_apply = springAnimation;
                    super(0);
                }
            }));
            $this$apply.animateToFinalPosition(this.strokeWidth);
        } else if (!iconSame && !this.strokeAnimation.isRunning()) {
            SpringAnimation springAnimation = this.scaleAnimation;
            boolean bl = false;
            boolean bl4 = false;
            SpringAnimation $this$apply = springAnimation;
            boolean bl5 = false;
            ViewExtensionsKt.withOneShotEndListener((SpringAnimation)$this$apply, (Function0)((Function0)new Function0<Unit>($this$apply){
                final /* synthetic */ SpringAnimation $this_apply;

                public final void invoke() {
                    this.$this_apply.animateToFinalPosition(1000.0f);
                }
                {
                    this.$this_apply = springAnimation;
                    super(0);
                }
            }));
            $this$apply.animateToFinalPosition(800.0f);
        }
    }

    public FabExtensionAnimator(@NotNull MaterialButton button, int collapsedFabSize, int expandedFabHeight) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        this.button = button;
        Context context = this.button.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"button.context");
        this.strokeWidth = (float)context.getResources().getDimensionPixelSize(R.dimen.fab_halo_width) * 100.0f;
        CharSequence charSequence = this.button.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"button.text");
        this.glyphState = new SimpleGlyphState(charSequence, this.button.getIcon());
        this.sizeInterpolator = new SpringSizeInterpolator(this.button, collapsedFabSize, expandedFabHeight);
        this.strokeAnimation = new SpringAnimation((Object)this.button, (FloatPropertyCompat)new StrokeWidthProperty(this.button), this.strokeWidth);
        this.scaleAnimation = new SpringAnimation((Object)this.button, (FloatPropertyCompat)new ScaleProperty(), 0.8f);
        this.isExtended = true;
        this.button.setCornerRadius(collapsedFabSize);
        this.button.setSingleLine();
        this.configureSpring((Function1<? super SpringAnimation, Unit>)((Function1)1.INSTANCE));
    }

    public /* synthetic */ FabExtensionAnimator(MaterialButton materialButton, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = materialButton.getResources().getDimensionPixelSize(R.dimen.collapsed_fab_size);
        }
        if ((n3 & 4) != 0) {
            n2 = materialButton.getResources().getDimensionPixelSize(R.dimen.extended_fab_height);
        }
        this(materialButton, n, n2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/tunjid/androidx/material/animator/FabExtensionAnimator$GlyphState;", "", "()V", "icon", "Landroid/graphics/drawable/Drawable;", "getIcon", "()Landroid/graphics/drawable/Drawable;", "text", "", "getText", "()Ljava/lang/CharSequence;", "com.tunjid.androidx.material"})
    public static abstract class GlyphState {
        @Nullable
        public abstract Drawable getIcon();

        @NotNull
        public abstract CharSequence getText();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/tunjid/androidx/material/animator/FabExtensionAnimator$SimpleGlyphState;", "Lcom/tunjid/androidx/material/animator/FabExtensionAnimator$GlyphState;", "text", "", "icon", "Landroid/graphics/drawable/Drawable;", "(Ljava/lang/CharSequence;Landroid/graphics/drawable/Drawable;)V", "getIcon", "()Landroid/graphics/drawable/Drawable;", "getText", "()Ljava/lang/CharSequence;", "equals", "", "other", "", "hashCode", "", "com.tunjid.androidx.material"})
    public static final class SimpleGlyphState
    extends GlyphState {
        @NotNull
        private final CharSequence text;
        @Nullable
        private final Drawable icon;

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
                return false;
            }
            SimpleGlyphState that = (SimpleGlyphState)other;
            return Intrinsics.areEqual((Object)this.getIcon(), (Object)that.getIcon()) && Intrinsics.areEqual((Object)this.getText(), (Object)that.getText());
        }

        public int hashCode() {
            return Objects.hash(this.getIcon(), this.getText());
        }

        @Override
        @NotNull
        public CharSequence getText() {
            return this.text;
        }

        @Override
        @Nullable
        public Drawable getIcon() {
            return this.icon;
        }

        public SimpleGlyphState(@NotNull CharSequence text, @Nullable Drawable icon) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
            this.icon = icon;
        }
    }
}

