/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle3.android;

import android.view.View;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import com.trello.rxlifecycle3.LifecycleTransformer;
import com.trello.rxlifecycle3.OutsideLifecycleException;
import com.trello.rxlifecycle3.RxLifecycle;
import com.trello.rxlifecycle3.android.ActivityEvent;
import com.trello.rxlifecycle3.android.FragmentEvent;
import com.trello.rxlifecycle3.android.ViewDetachesOnSubscribe;
import com.trello.rxlifecycle3.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.functions.Function;

public class RxLifecycleAndroid {
    private static final Function<ActivityEvent, ActivityEvent> ACTIVITY_LIFECYCLE = new Function<ActivityEvent, ActivityEvent>(){

        public ActivityEvent apply(ActivityEvent lastEvent) throws Exception {
            switch (lastEvent) {
                case CREATE: {
                    return ActivityEvent.DESTROY;
                }
                case START: {
                    return ActivityEvent.STOP;
                }
                case RESUME: {
                    return ActivityEvent.PAUSE;
                }
                case PAUSE: {
                    return ActivityEvent.STOP;
                }
                case STOP: {
                    return ActivityEvent.DESTROY;
                }
                case DESTROY: {
                    throw new OutsideLifecycleException("Cannot bind to Activity lifecycle when outside of it.");
                }
            }
            throw new UnsupportedOperationException("Binding to " + (Object)((Object)lastEvent) + " not yet implemented");
        }
    };
    private static final Function<FragmentEvent, FragmentEvent> FRAGMENT_LIFECYCLE = new Function<FragmentEvent, FragmentEvent>(){

        public FragmentEvent apply(FragmentEvent lastEvent) throws Exception {
            switch (lastEvent) {
                case ATTACH: {
                    return FragmentEvent.DETACH;
                }
                case CREATE: {
                    return FragmentEvent.DESTROY;
                }
                case CREATE_VIEW: {
                    return FragmentEvent.DESTROY_VIEW;
                }
                case START: {
                    return FragmentEvent.STOP;
                }
                case RESUME: {
                    return FragmentEvent.PAUSE;
                }
                case PAUSE: {
                    return FragmentEvent.STOP;
                }
                case STOP: {
                    return FragmentEvent.DESTROY_VIEW;
                }
                case DESTROY_VIEW: {
                    return FragmentEvent.DESTROY;
                }
                case DESTROY: {
                    return FragmentEvent.DETACH;
                }
                case DETACH: {
                    throw new OutsideLifecycleException("Cannot bind to Fragment lifecycle when outside of it.");
                }
            }
            throw new UnsupportedOperationException("Binding to " + (Object)((Object)lastEvent) + " not yet implemented");
        }
    };

    private RxLifecycleAndroid() {
        throw new AssertionError((Object)"No instances");
    }

    @NonNull
    @CheckResult
    public static <T> LifecycleTransformer<T> bindActivity(@NonNull Observable<ActivityEvent> lifecycle) {
        return RxLifecycle.bind(lifecycle, ACTIVITY_LIFECYCLE);
    }

    @NonNull
    @CheckResult
    public static <T> LifecycleTransformer<T> bindFragment(@NonNull Observable<FragmentEvent> lifecycle) {
        return RxLifecycle.bind(lifecycle, FRAGMENT_LIFECYCLE);
    }

    @NonNull
    @CheckResult
    public static <T> LifecycleTransformer<T> bindView(@NonNull View view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return RxLifecycle.bind((Observable)Observable.create((ObservableOnSubscribe)new ViewDetachesOnSubscribe(view)));
    }
}

