/*
 * Decompiled with CFR 0.152.
 */
package com.trello.lifecycle2.android.lifecycle;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.OnLifecycleEvent;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import com.trello.lifecycle2.android.lifecycle.RxLifecycleAndroidLifecycle;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.trello.rxlifecycle2.LifecycleTransformer;
import com.trello.rxlifecycle2.RxLifecycle;
import io.reactivex.Observable;
import io.reactivex.subjects.BehaviorSubject;

public final class AndroidLifecycle
implements LifecycleProvider<Lifecycle.Event>,
LifecycleObserver {
    private final BehaviorSubject<Lifecycle.Event> lifecycleSubject = BehaviorSubject.create();

    public static LifecycleProvider<Lifecycle.Event> createLifecycleProvider(LifecycleOwner owner) {
        return new AndroidLifecycle(owner);
    }

    private AndroidLifecycle(LifecycleOwner owner) {
        owner.getLifecycle().addObserver((LifecycleObserver)this);
    }

    @NonNull
    @CheckResult
    public Observable<Lifecycle.Event> lifecycle() {
        return this.lifecycleSubject.hide();
    }

    @NonNull
    @CheckResult
    public <T> LifecycleTransformer<T> bindUntilEvent(@NonNull Lifecycle.Event event) {
        return RxLifecycle.bindUntilEvent(this.lifecycleSubject, (Object)event);
    }

    @NonNull
    @CheckResult
    public <T> LifecycleTransformer<T> bindToLifecycle() {
        return RxLifecycleAndroidLifecycle.bindLifecycle(this.lifecycleSubject);
    }

    @OnLifecycleEvent(value={Lifecycle.Event.ON_ANY})
    void onEvent(LifecycleOwner owner, Lifecycle.Event event) {
        this.lifecycleSubject.onNext((Object)event);
        if (event == Lifecycle.Event.ON_DESTROY) {
            owner.getLifecycle().removeObserver((LifecycleObserver)this);
        }
    }
}

