/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.color;

import android.graphics.Bitmap;
import android.util.Log;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSObject;
import com.tom_roush.pdfbox.pdmodel.MissingResourceException;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.ResourceCache;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColor;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import java.io.IOException;

public abstract class PDColorSpace
implements COSObjectable {
    protected COSArray array;

    public static PDColorSpace create(COSBase colorSpace) throws IOException {
        return PDColorSpace.create(colorSpace, null);
    }

    public static PDColorSpace create(COSBase colorSpace, PDResources resources) throws IOException {
        return PDColorSpace.create(colorSpace, resources, false);
    }

    public static PDColorSpace create(COSBase colorSpace, PDResources resources, boolean wasDefault) throws IOException {
        if (colorSpace instanceof COSObject) {
            return PDColorSpace.createFromCOSObject((COSObject)colorSpace, resources);
        }
        if (colorSpace instanceof COSName) {
            COSName name = (COSName)colorSpace;
            if (resources != null) {
                COSName defaultName = null;
                if (name.equals(COSName.DEVICECMYK) && resources.hasColorSpace(COSName.DEFAULT_CMYK)) {
                    defaultName = COSName.DEFAULT_CMYK;
                } else if (name.equals(COSName.DEVICERGB) && resources.hasColorSpace(COSName.DEFAULT_RGB)) {
                    defaultName = COSName.DEFAULT_RGB;
                } else if (name.equals(COSName.DEVICEGRAY) && resources.hasColorSpace(COSName.DEFAULT_GRAY)) {
                    defaultName = COSName.DEFAULT_GRAY;
                }
                if (resources.hasColorSpace(defaultName) && !wasDefault) {
                    return resources.getColorSpace(defaultName, true);
                }
            }
            if (name == COSName.DEVICECMYK) {
                Log.e((String)"PdfBox-Android", (String)("Unsupported color space kind: " + name + ". Will try DeviceRGB instead"));
                return PDDeviceRGB.INSTANCE;
            }
            if (name == COSName.DEVICERGB) {
                return PDDeviceRGB.INSTANCE;
            }
            if (name == COSName.DEVICEGRAY) {
                return PDDeviceGray.INSTANCE;
            }
            if (name == COSName.PATTERN) {
                Log.e((String)"PdfBox-Android", (String)("Unsupported color space kind: " + name + ". Will try DeviceRGB instead"));
                return PDDeviceRGB.INSTANCE;
            }
            if (resources != null) {
                if (!resources.hasColorSpace(name)) {
                    throw new MissingResourceException("Missing color space: " + name.getName());
                }
                return resources.getColorSpace(name);
            }
            throw new MissingResourceException("Unknown color space: " + name.getName());
        }
        if (colorSpace instanceof COSArray) {
            COSArray array = (COSArray)colorSpace;
            if (array.size() == 0) {
                throw new IOException("Colorspace array is empty");
            }
            COSBase base = array.getObject(0);
            if (!(base instanceof COSName)) {
                throw new IOException("First element in colorspace array must be a name");
            }
            COSName name = (COSName)base;
            if (name == COSName.CALGRAY) {
                Log.e((String)"PdfBox-Android", (String)("Unsupported color space kind: " + name + ". Will try DeviceRGB instead"));
                return PDDeviceRGB.INSTANCE;
            }
            if (name == COSName.CALRGB) {
                Log.e((String)"PdfBox-Android", (String)("Unsupported color space kind: " + name + ". Will try DeviceRGB instead"));
                return PDDeviceRGB.INSTANCE;
            }
            if (name == COSName.DEVICEN) {
                Log.e((String)"PdfBox-Android", (String)("Unsupported color space kind: " + name + ". Will try DeviceRGB instead"));
                return PDDeviceRGB.INSTANCE;
            }
            if (name == COSName.INDEXED) {
                Log.e((String)"PdfBox-Android", (String)("Unsupported color space kind: " + name + ". Will try DeviceRGB instead"));
                return PDDeviceRGB.INSTANCE;
            }
            if (name == COSName.SEPARATION) {
                Log.e((String)"PdfBox-Android", (String)("Unsupported color space kind: " + name + ". Will try DeviceRGB instead"));
                return PDDeviceRGB.INSTANCE;
            }
            if (name == COSName.ICCBASED) {
                Log.e((String)"PdfBox-Android", (String)("Unsupported color space kind: " + name + ". Will try DeviceRGB instead"));
                return PDDeviceRGB.INSTANCE;
            }
            if (name == COSName.LAB) {
                Log.e((String)"PdfBox-Android", (String)("Unsupported color space kind: " + name + ". Will try DeviceRGB instead"));
                return PDDeviceRGB.INSTANCE;
            }
            if (name == COSName.PATTERN) {
                if (array.size() == 1) {
                    // empty if block
                }
                Log.e((String)"PdfBox-Android", (String)("Unsupported color space kind: " + name + ". Will try DeviceRGB instead"));
                return PDDeviceRGB.INSTANCE;
            }
            if (name == COSName.DEVICECMYK || name == COSName.DEVICERGB || name == COSName.DEVICEGRAY) {
                return PDColorSpace.create(name, resources, wasDefault);
            }
            throw new IOException("Invalid color space kind: " + name);
        }
        if (colorSpace instanceof COSDictionary && ((COSDictionary)colorSpace).containsKey(COSName.COLORSPACE)) {
            COSBase base = ((COSDictionary)colorSpace).getDictionaryObject(COSName.COLORSPACE);
            if (base == colorSpace) {
                throw new IOException("Recursion in colorspace: " + ((COSDictionary)colorSpace).getItem(COSName.COLORSPACE) + " points to itself");
            }
            return PDColorSpace.create(base, resources, wasDefault);
        }
        throw new IOException("Expected a name or array but got: " + colorSpace);
    }

    private static PDColorSpace createFromCOSObject(COSObject colorSpace, PDResources resources) throws IOException {
        ResourceCache resourceCache;
        PDColorSpace cs;
        if (resources != null && resources.getResourceCache() != null && (cs = (resourceCache = resources.getResourceCache()).getColorSpace(colorSpace)) != null) {
            return cs;
        }
        cs = PDColorSpace.create(colorSpace.getObject(), resources);
        if (resources != null && resources.getResourceCache() != null && cs != null) {
            resourceCache = resources.getResourceCache();
            resourceCache.put(colorSpace, cs);
        }
        return cs;
    }

    public abstract String getName();

    public abstract int getNumberOfComponents();

    public abstract float[] getDefaultDecode(int var1);

    public abstract PDColor getInitialColor();

    public abstract float[] toRGB(float[] var1) throws IOException;

    public abstract Bitmap toRGBImage(Bitmap var1) throws IOException;

    @Override
    public COSBase getCOSObject() {
        return this.array;
    }
}

