/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.font;

import com.tom_roush.fontbox.cmap.CMap;
import com.tom_roush.fontbox.cmap.CMapParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class CMapManager {
    private static final Map<String, CMap> CMAP_CACHE = new ConcurrentHashMap<String, CMap>();

    private CMapManager() {
    }

    public static CMap getPredefinedCMap(String cMapName) throws IOException {
        CMap cmap = CMAP_CACHE.get(cMapName);
        if (cmap != null) {
            return cmap;
        }
        CMap targetCmap = new CMapParser().parsePredefined(cMapName);
        CMAP_CACHE.put(targetCmap.getName(), targetCmap);
        return targetCmap;
    }

    public static CMap parseCMap(InputStream cMapStream) throws IOException {
        CMap targetCmap = null;
        if (cMapStream != null) {
            targetCmap = new CMapParser(true).parse(cMapStream);
        }
        return targetCmap;
    }
}

