/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.filter;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.filter.DecodeOptions;
import com.tom_roush.pdfbox.filter.DecodeResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Filter {
    public static final String SYSPROP_DEFLATELEVEL = "com.tom_roush.pdfbox.filter.deflatelevel";

    protected Filter() {
    }

    public abstract DecodeResult decode(InputStream var1, OutputStream var2, COSDictionary var3, int var4) throws IOException;

    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index, DecodeOptions options) throws IOException {
        return this.decode(encoded, decoded, parameters, index);
    }

    public final void encode(InputStream input, OutputStream encoded, COSDictionary parameters, int index) throws IOException {
        this.encode(input, encoded, parameters.asUnmodifiableDictionary());
    }

    protected abstract void encode(InputStream var1, OutputStream var2, COSDictionary var3) throws IOException;

    protected COSDictionary getDecodeParams(COSDictionary dictionary, int index) {
        COSBase filter = dictionary.getDictionaryObject(COSName.F, COSName.FILTER);
        COSBase obj = dictionary.getDictionaryObject(COSName.DP, COSName.DECODE_PARMS);
        if (filter instanceof COSName && obj instanceof COSDictionary) {
            return (COSDictionary)obj;
        }
        if (filter instanceof COSArray && obj instanceof COSArray) {
            COSBase objAtIndex;
            COSArray array = (COSArray)obj;
            if (index < array.size() && (objAtIndex = array.getObject(index)) instanceof COSDictionary) {
                return (COSDictionary)objAtIndex;
            }
        } else if (obj != null && !(filter instanceof COSArray) && !(obj instanceof COSArray)) {
            Log.e((String)"PdfBox-Android", (String)("Expected DecodeParams to be an Array or Dictionary but found " + obj.getClass().getName()));
        }
        return new COSDictionary();
    }

    public static int getCompressionLevel() {
        int compressionLevel = -1;
        try {
            compressionLevel = Integer.parseInt(System.getProperty(SYSPROP_DEFLATELEVEL, "-1"));
        }
        catch (NumberFormatException ex) {
            Log.w((String)"PdfBox-Android", (String)ex.getMessage(), (Throwable)ex);
        }
        return Math.max(-1, Math.min(9, compressionLevel));
    }
}

