/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tom_roush.pdfbox.pdmodel.documentinterchange.logicalstructure;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;

/**
 * Described in the PDF specification in the ParentTree segment of the table "Entries in the
 * structure tree root". This is either a dictionary or an array.
 *
 * @author Tilman Hausherr
 */
public class PDParentTreeValue implements COSObjectable
{
    COSObjectable obj;

    public PDParentTreeValue(COSArray obj)
    {
        this.obj = obj;
    }

    public PDParentTreeValue(COSDictionary obj)
    {
        this.obj = obj;
    }

    @Override
    public COSBase getCOSObject()
    {
        return obj.getCOSObject();
    }

    @Override
    public String toString()
    {
        return obj.toString();
    }
}
