/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.shading;

import android.graphics.Point;
import android.graphics.PointF;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.Line;
import java.util.HashSet;

class ShadedTriangle {
    protected final PointF[] corner;
    protected final float[][] color;
    private final double area;
    private final int degree;
    private final Line line;
    private final double v0;
    private final double v1;
    private final double v2;

    ShadedTriangle(PointF[] p, float[][] c) {
        this.corner = (PointF[])p.clone();
        this.color = (float[][])c.clone();
        this.area = this.getArea(p[0], p[1], p[2]);
        this.degree = this.calcDeg(p);
        if (this.degree == 2) {
            if (this.overlaps(this.corner[1], this.corner[2]) && !this.overlaps(this.corner[0], this.corner[2])) {
                Point p0 = new Point(Math.round(this.corner[0].x), Math.round(this.corner[0].y));
                Point p1 = new Point(Math.round(this.corner[2].x), Math.round(this.corner[2].y));
                this.line = new Line(p0, p1, this.color[0], this.color[2]);
            } else {
                Point p0 = new Point(Math.round(this.corner[1].x), Math.round(this.corner[1].y));
                Point p1 = new Point(Math.round(this.corner[2].x), Math.round(this.corner[2].y));
                this.line = new Line(p0, p1, this.color[1], this.color[2]);
            }
        } else {
            this.line = null;
        }
        this.v0 = this.edgeEquationValue(p[0], p[1], p[2]);
        this.v1 = this.edgeEquationValue(p[1], p[2], p[0]);
        this.v2 = this.edgeEquationValue(p[2], p[0], p[1]);
    }

    private int calcDeg(PointF[] p) {
        HashSet<Point> set = new HashSet<Point>();
        for (PointF itp : p) {
            Point np = new Point(Math.round(itp.x * 1000.0f), Math.round(itp.y * 1000.0f));
            set.add(np);
        }
        return set.size();
    }

    public int getDeg() {
        return this.degree;
    }

    public int[] getBoundary() {
        int[] boundary = new int[4];
        int x0 = Math.round(this.corner[0].x);
        int x1 = Math.round(this.corner[1].x);
        int x2 = Math.round(this.corner[2].x);
        int y0 = Math.round(this.corner[0].y);
        int y1 = Math.round(this.corner[1].y);
        int y2 = Math.round(this.corner[2].y);
        boundary[0] = Math.min(Math.min(x0, x1), x2);
        boundary[1] = Math.max(Math.max(x0, x1), x2);
        boundary[2] = Math.min(Math.min(y0, y1), y2);
        boundary[3] = Math.max(Math.max(y0, y1), y2);
        return boundary;
    }

    public Line getLine() {
        return this.line;
    }

    public boolean contains(PointF p) {
        if (this.degree == 1) {
            return this.overlaps(this.corner[0], p) || this.overlaps(this.corner[1], p) || this.overlaps(this.corner[2], p);
        }
        if (this.degree == 2) {
            Point tp = new Point(Math.round(p.x), Math.round(p.y));
            return this.line.linePoints.contains(tp);
        }
        double pv0 = this.edgeEquationValue(p, this.corner[1], this.corner[2]);
        if (pv0 * this.v0 < 0.0) {
            return false;
        }
        double pv1 = this.edgeEquationValue(p, this.corner[2], this.corner[0]);
        if (pv1 * this.v1 < 0.0) {
            return false;
        }
        double pv2 = this.edgeEquationValue(p, this.corner[0], this.corner[1]);
        return pv2 * this.v2 >= 0.0;
    }

    private boolean overlaps(PointF p0, PointF p1) {
        return (double)Math.abs(p0.x - p1.x) < 0.001 && (double)Math.abs(p0.y - p1.y) < 0.001;
    }

    private double edgeEquationValue(PointF p, PointF p1, PointF p2) {
        return (p2.y - p1.y) * (p.x - p1.x) - (p2.x - p1.x) * (p.y - p1.y);
    }

    private double getArea(PointF a, PointF b, PointF c) {
        return (double)Math.abs((c.x - b.x) * (c.y - a.y) - (c.x - a.x) * (c.y - b.y)) / 2.0;
    }

    public float[] calcColor(PointF p) {
        int numberOfColorComponents = this.color[0].length;
        float[] pCol = new float[numberOfColorComponents];
        switch (this.degree) {
            case 1: {
                for (int i = 0; i < numberOfColorComponents; ++i) {
                    pCol[i] = (this.color[0][i] + this.color[1][i] + this.color[2][i]) / 3.0f;
                }
                break;
            }
            case 2: {
                Point tp = new Point(Math.round(p.x), Math.round(p.y));
                return this.line.calcColor(tp);
            }
            default: {
                float aw = (float)(this.getArea(p, this.corner[1], this.corner[2]) / this.area);
                float bw = (float)(this.getArea(p, this.corner[2], this.corner[0]) / this.area);
                float cw = (float)(this.getArea(p, this.corner[0], this.corner[1]) / this.area);
                for (int i = 0; i < numberOfColorComponents; ++i) {
                    pCol[i] = this.color[0][i] * aw + this.color[1][i] * bw + this.color[2][i] * cw;
                }
            }
        }
        return pCol;
    }

    public String toString() {
        return this.corner[0] + " " + this.corner[1] + " " + this.corner[2];
    }
}

