/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.shading;

import android.graphics.PointF;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.CoordinateColorPair;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.ShadedTriangle;
import java.util.ArrayList;
import java.util.List;

abstract class Patch {
    protected PointF[][] controlPoints;
    protected float[][] cornerColor;
    protected int[] level;
    protected List<ShadedTriangle> listOfTriangles;

    Patch(float[][] color) {
        this.cornerColor = (float[][])color.clone();
    }

    protected abstract PointF[] getFlag1Edge();

    protected abstract PointF[] getFlag2Edge();

    protected abstract PointF[] getFlag3Edge();

    protected float[][] getFlag1Color() {
        int numberOfColorComponents = this.cornerColor[0].length;
        float[][] implicitCornerColor = new float[2][numberOfColorComponents];
        for (int i = 0; i < numberOfColorComponents; ++i) {
            implicitCornerColor[0][i] = this.cornerColor[1][i];
            implicitCornerColor[1][i] = this.cornerColor[2][i];
        }
        return implicitCornerColor;
    }

    protected float[][] getFlag2Color() {
        int numberOfColorComponents = this.cornerColor[0].length;
        float[][] implicitCornerColor = new float[2][numberOfColorComponents];
        for (int i = 0; i < numberOfColorComponents; ++i) {
            implicitCornerColor[0][i] = this.cornerColor[2][i];
            implicitCornerColor[1][i] = this.cornerColor[3][i];
        }
        return implicitCornerColor;
    }

    protected float[][] getFlag3Color() {
        int numberOfColorComponents = this.cornerColor[0].length;
        float[][] implicitCornerColor = new float[2][numberOfColorComponents];
        for (int i = 0; i < numberOfColorComponents; ++i) {
            implicitCornerColor[0][i] = this.cornerColor[3][i];
            implicitCornerColor[1][i] = this.cornerColor[0][i];
        }
        return implicitCornerColor;
    }

    protected double getLen(PointF ps, PointF pe) {
        double x = pe.x - ps.x;
        double y = pe.y - ps.y;
        return Math.sqrt(x * x + y * y);
    }

    protected boolean isEdgeALine(PointF[] ctl) {
        double ctl1 = Math.abs(this.edgeEquationValue(ctl[1], ctl[0], ctl[3]));
        double ctl2 = Math.abs(this.edgeEquationValue(ctl[2], ctl[0], ctl[3]));
        double x = Math.abs(ctl[0].x - ctl[3].x);
        double y = Math.abs(ctl[0].y - ctl[3].y);
        return ctl1 <= x && ctl2 <= x || ctl1 <= y && ctl2 <= y;
    }

    protected double edgeEquationValue(PointF p, PointF p1, PointF p2) {
        return (p2.y - p1.y) * (p.x - p1.x) - (p2.x - p1.x) * (p.y - p1.y);
    }

    protected List<ShadedTriangle> getShadedTriangles(CoordinateColorPair[][] patchCC) {
        ArrayList<ShadedTriangle> list = new ArrayList<ShadedTriangle>();
        int szV = patchCC.length;
        int szU = patchCC[0].length;
        for (int i = 1; i < szV; ++i) {
            for (int j = 1; j < szU; ++j) {
                PointF p0 = patchCC[i - 1][j - 1].coordinate;
                PointF p1 = patchCC[i - 1][j].coordinate;
                PointF p2 = patchCC[i][j].coordinate;
                PointF p3 = patchCC[i][j - 1].coordinate;
                boolean ll = true;
                if (this.overlaps(p0, p1) || this.overlaps(p0, p3)) {
                    ll = false;
                } else {
                    PointF[] llCorner = new PointF[]{p0, p1, p3};
                    float[][] llColor = new float[][]{patchCC[i - 1][j - 1].color, patchCC[i - 1][j].color, patchCC[i][j - 1].color};
                    ShadedTriangle tmpll = new ShadedTriangle(llCorner, llColor);
                    list.add(tmpll);
                }
                if (ll && (this.overlaps(p2, p1) || this.overlaps(p2, p3))) continue;
                PointF[] urCorner = new PointF[]{p3, p1, p2};
                float[][] urColor = new float[][]{patchCC[i][j - 1].color, patchCC[i - 1][j].color, patchCC[i][j].color};
                ShadedTriangle tmpur = new ShadedTriangle(urCorner, urColor);
                list.add(tmpur);
            }
        }
        return list;
    }

    private boolean overlaps(PointF p0, PointF p1) {
        return (double)Math.abs(p0.x - p1.x) < 0.001 && (double)Math.abs(p0.y - p1.y) < 0.001;
    }
}

