/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.shading;

import android.graphics.PointF;
import android.util.Log;
import com.tom_roush.harmony.awt.geom.AffineTransform;
import com.tom_roush.harmony.javax.imageio.stream.MemoryCacheImageInputStream;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdmodel.common.PDRange;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.PDTriangleBasedShadingType;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.ShadedTriangle;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.Vertex;
import com.tom_roush.pdfbox.util.Matrix;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PDShadingType4
extends PDTriangleBasedShadingType {
    public PDShadingType4(COSDictionary shadingDictionary) {
        super(shadingDictionary);
    }

    @Override
    public int getShadingType() {
        return 4;
    }

    public int getBitsPerFlag() {
        return this.getCOSObject().getInt(COSName.BITS_PER_FLAG, -1);
    }

    public void setBitsPerFlag(int bitsPerFlag) {
        this.getCOSObject().setInt(COSName.BITS_PER_FLAG, bitsPerFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<ShadedTriangle> collectTriangles(AffineTransform xform, Matrix matrix) throws IOException {
        int bitsPerFlag = this.getBitsPerFlag();
        COSDictionary dict = this.getCOSObject();
        if (!(dict instanceof COSStream)) {
            return Collections.emptyList();
        }
        PDRange rangeX = this.getDecodeForParameter(0);
        PDRange rangeY = this.getDecodeForParameter(1);
        if (Float.compare(rangeX.getMin(), rangeX.getMax()) == 0 || Float.compare(rangeY.getMin(), rangeY.getMax()) == 0) {
            return Collections.emptyList();
        }
        PDRange[] colRange = new PDRange[this.getNumberOfColorComponents()];
        for (int i = 0; i < colRange.length; ++i) {
            colRange[i] = this.getDecodeForParameter(2 + i);
        }
        ArrayList<ShadedTriangle> list = new ArrayList<ShadedTriangle>();
        long maxSrcCoord = (long)Math.pow(2.0, this.getBitsPerCoordinate()) - 1L;
        long maxSrcColor = (long)Math.pow(2.0, this.getBitsPerComponent()) - 1L;
        COSStream stream = (COSStream)dict;
        try (MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(stream.createInputStream());){
            byte flag = 0;
            try {
                flag = (byte)(mciis.readBits(bitsPerFlag) & 3L);
            }
            catch (EOFException ex) {
                Log.e((String)"PdfBox-Android", (String)ex.getMessage(), (Throwable)ex);
            }
            boolean eof = false;
            block12: while (!eof) {
                try {
                    switch (flag) {
                        case 0: {
                            Vertex p0 = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, matrix, xform);
                            flag = (byte)(mciis.readBits(bitsPerFlag) & 3L);
                            if (flag != 0) {
                                Log.e((String)"PdfBox-Android", (String)("bad triangle: " + flag));
                            }
                            Vertex p1 = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, matrix, xform);
                            mciis.readBits(bitsPerFlag);
                            if (flag != 0) {
                                Log.e((String)"PdfBox-Android", (String)("bad triangle: " + flag));
                            }
                            Vertex p2 = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, matrix, xform);
                            PointF[] ps = new PointF[]{p0.point, p1.point, p2.point};
                            float[][] cs = new float[][]{p0.color, p1.color, p2.color};
                            list.add(new ShadedTriangle(ps, cs));
                            flag = (byte)(mciis.readBits(bitsPerFlag) & 3L);
                            continue block12;
                        }
                        case 1: 
                        case 2: {
                            int lastIndex = list.size() - 1;
                            if (lastIndex < 0) {
                                Log.e((String)"PdfBox-Android", (String)("broken data stream: " + list.size()));
                                continue block12;
                            }
                            ShadedTriangle preTri = (ShadedTriangle)list.get(lastIndex);
                            Vertex p2 = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, matrix, xform);
                            PointF[] ps = new PointF[]{flag == 1 ? preTri.corner[1] : preTri.corner[0], preTri.corner[2], p2.point};
                            float[][] cs = new float[][]{flag == 1 ? preTri.color[1] : preTri.color[0], preTri.color[2], p2.color};
                            list.add(new ShadedTriangle(ps, cs));
                            flag = (byte)(mciis.readBits(bitsPerFlag) & 3L);
                            continue block12;
                        }
                    }
                    Log.w((String)"PdfBox-Android", (String)("bad flag: " + flag));
                }
                catch (EOFException ex) {
                    eof = true;
                }
            }
        }
        return list;
    }
}

