/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.color;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorSpace;
import android.os.Build;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColor;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import java.io.IOException;

public final class PDJPXColorSpace
extends PDColorSpace {
    private final ColorSpace colorSpace;

    public PDJPXColorSpace(ColorSpace colorSpace) {
        this.colorSpace = colorSpace;
    }

    @Override
    public String getName() {
        return "JPX";
    }

    @Override
    public int getNumberOfComponents() {
        if (Build.VERSION.SDK_INT > 26) {
            return this.colorSpace.getComponentCount();
        }
        return 0;
    }

    @Override
    public float[] getDefaultDecode(int bitsPerComponent) {
        if (Build.VERSION.SDK_INT > 26) {
            int n = this.getNumberOfComponents();
            float[] decode = new float[n * 2];
            for (int i = 0; i < n; ++i) {
                decode[i * 2] = this.colorSpace.getMinValue(i);
                decode[i * 2 + 1] = this.colorSpace.getMaxValue(i);
            }
            return decode;
        }
        return new float[0];
    }

    @Override
    public PDColor getInitialColor() {
        throw new UnsupportedOperationException("JPX color spaces don't support drawing");
    }

    @Override
    public float[] toRGB(float[] value) {
        throw new UnsupportedOperationException("JPX color spaces don't support drawing");
    }

    @Override
    public Bitmap toRGBImage(Bitmap raster) throws IOException {
        if (Build.VERSION.SDK_INT > 26) {
            Bitmap dest = Bitmap.createBitmap((int)raster.getWidth(), (int)raster.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565, (boolean)false, (ColorSpace)this.colorSpace);
            Canvas canvas = new Canvas(dest);
            canvas.drawBitmap(raster, 0.0f, 0.0f, null);
            return dest;
        }
        return raster;
    }

    @Override
    public COSBase getCOSObject() {
        throw new UnsupportedOperationException("JPX color spaces don't have COS objects");
    }
}

