/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.fdf;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.cos.COSString;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.interactive.action.PDAction;
import com.tom_roush.pdfbox.pdmodel.interactive.action.PDActionFactory;
import com.tom_roush.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import java.util.LinkedHashMap;
import java.util.Map;

public class FDFJavaScript
implements COSObjectable {
    private final COSDictionary dictionary;

    public FDFJavaScript() {
        this.dictionary = new COSDictionary();
    }

    public FDFJavaScript(COSDictionary javaScript) {
        this.dictionary = javaScript;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public String getBefore() {
        COSBase base = this.dictionary.getDictionaryObject(COSName.BEFORE);
        if (base instanceof COSString) {
            return ((COSString)base).getString();
        }
        if (base instanceof COSStream) {
            return ((COSStream)base).toTextString();
        }
        return null;
    }

    public void setBefore(String before) {
        this.dictionary.setItem(COSName.BEFORE, (COSBase)new COSString(before));
    }

    public String getAfter() {
        COSBase base = this.dictionary.getDictionaryObject(COSName.AFTER);
        if (base instanceof COSString) {
            return ((COSString)base).getString();
        }
        if (base instanceof COSStream) {
            return ((COSStream)base).toTextString();
        }
        return null;
    }

    public void setAfter(String after) {
        this.dictionary.setItem(COSName.AFTER, (COSBase)new COSString(after));
    }

    public Map<String, PDActionJavaScript> getDoc() {
        LinkedHashMap<String, PDActionJavaScript> map = new LinkedHashMap<String, PDActionJavaScript>();
        COSArray array = this.dictionary.getCOSArray(COSName.DOC);
        if (array == null) {
            return null;
        }
        int i = 0;
        while (i + 1 < array.size()) {
            PDAction action;
            COSBase base;
            String name = array.getName(i);
            if (name != null && (base = array.getObject(i + 1)) instanceof COSDictionary && (action = PDActionFactory.createAction((COSDictionary)base)) instanceof PDActionJavaScript) {
                map.put(name, (PDActionJavaScript)action);
            }
            i += 2;
        }
        return map;
    }

    public void setDoc(Map<String, PDActionJavaScript> map) {
        COSArray array = new COSArray();
        for (Map.Entry<String, PDActionJavaScript> entry : map.entrySet()) {
            array.add(new COSString(entry.getKey()));
            array.add(entry.getValue());
        }
        this.dictionary.setItem(COSName.DOC, (COSBase)array);
    }
}

