/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.filter;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Build;
import com.gemalto.jp2.JP2Decoder;
import com.gemalto.jp2.JP2Encoder;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.filter.DecodeOptions;
import com.tom_roush.pdfbox.filter.DecodeResult;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.filter.MissingImageReaderException;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDJPXColorSpace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class JPXFilter
extends Filter {
    private static final int CACHE_SIZE = 1024;

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index, DecodeOptions options) throws IOException {
        DecodeResult result = new DecodeResult(new COSDictionary());
        result.getParameters().addAll(parameters);
        Bitmap image = this.readJPX(encoded, options, result);
        int arrLen = image.getWidth() * image.getHeight();
        int[] pixels = new int[arrLen];
        image.getPixels(pixels, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        byte[] buffer = new byte[3072];
        int pos = 0;
        for (int i = 0; i < arrLen; ++i) {
            if (pos + 3 >= buffer.length) {
                decoded.write(buffer, 0, pos);
                pos = 0;
            }
            int color = pixels[i];
            buffer[pos] = (byte)Color.red((int)color);
            buffer[pos + 1] = (byte)Color.green((int)color);
            buffer[pos + 2] = (byte)Color.blue((int)color);
            pos += 3;
        }
        decoded.write(buffer, 0, pos);
        return result;
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        return this.decode(encoded, decoded, parameters, index, DecodeOptions.DEFAULT);
    }

    private Bitmap readJPX(InputStream input, DecodeOptions options, DecodeResult result) throws IOException {
        try {
            Class.forName("com.gemalto.jp2.JP2Decoder");
        }
        catch (ClassNotFoundException ex) {
            throw new MissingImageReaderException("Cannot read JPX image: JP2Android is not installed.");
        }
        JP2Decoder decoder = new JP2Decoder(input);
        Bitmap image = decoder.decode();
        COSDictionary parameters = result.getParameters();
        if (!parameters.getBoolean(COSName.IMAGE_MASK, false)) {
            parameters.setItem(COSName.DECODE, null);
        }
        parameters.setInt(COSName.WIDTH, image.getWidth());
        parameters.setInt(COSName.HEIGHT, image.getHeight());
        if (!parameters.containsKey(COSName.COLORSPACE) && Build.VERSION.SDK_INT > 26) {
            result.setColorSpace(new PDJPXColorSpace(image.getColorSpace()));
        }
        return image;
    }

    @Override
    protected void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)input);
        byte[] jpeBytes = new JP2Encoder(bitmap).encode();
        IOUtils.copy(new ByteArrayInputStream(jpeBytes), encoded);
        encoded.flush();
    }
}

