/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.filter;

import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.filter.ASCII85Filter;
import com.tom_roush.pdfbox.filter.ASCIIHexFilter;
import com.tom_roush.pdfbox.filter.CCITTFaxFilter;
import com.tom_roush.pdfbox.filter.CryptFilter;
import com.tom_roush.pdfbox.filter.DCTFilter;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.filter.FlateFilter;
import com.tom_roush.pdfbox.filter.JPXFilter;
import com.tom_roush.pdfbox.filter.LZWFilter;
import com.tom_roush.pdfbox.filter.RunLengthDecodeFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class FilterFactory {
    public static final FilterFactory INSTANCE = new FilterFactory();
    private final Map<COSName, Filter> filters = new HashMap<COSName, Filter>();

    private FilterFactory() {
        FlateFilter flate = new FlateFilter();
        DCTFilter dct = new DCTFilter();
        CCITTFaxFilter ccittFax = new CCITTFaxFilter();
        LZWFilter lzw = new LZWFilter();
        ASCIIHexFilter asciiHex = new ASCIIHexFilter();
        ASCII85Filter ascii85 = new ASCII85Filter();
        RunLengthDecodeFilter runLength = new RunLengthDecodeFilter();
        CryptFilter crypt = new CryptFilter();
        JPXFilter jpx = new JPXFilter();
        this.filters.put(COSName.FLATE_DECODE, flate);
        this.filters.put(COSName.FLATE_DECODE_ABBREVIATION, flate);
        this.filters.put(COSName.DCT_DECODE, dct);
        this.filters.put(COSName.DCT_DECODE_ABBREVIATION, dct);
        this.filters.put(COSName.CCITTFAX_DECODE, ccittFax);
        this.filters.put(COSName.CCITTFAX_DECODE_ABBREVIATION, ccittFax);
        this.filters.put(COSName.LZW_DECODE, lzw);
        this.filters.put(COSName.LZW_DECODE_ABBREVIATION, lzw);
        this.filters.put(COSName.ASCII_HEX_DECODE, asciiHex);
        this.filters.put(COSName.ASCII_HEX_DECODE_ABBREVIATION, asciiHex);
        this.filters.put(COSName.ASCII85_DECODE, ascii85);
        this.filters.put(COSName.ASCII85_DECODE_ABBREVIATION, ascii85);
        this.filters.put(COSName.RUN_LENGTH_DECODE, runLength);
        this.filters.put(COSName.RUN_LENGTH_DECODE_ABBREVIATION, runLength);
        this.filters.put(COSName.CRYPT, crypt);
        this.filters.put(COSName.JPX_DECODE, jpx);
    }

    public Filter getFilter(String filterName) throws IOException {
        return this.getFilter(COSName.getPDFName(filterName));
    }

    public Filter getFilter(COSName filterName) throws IOException {
        Filter filter = this.filters.get(filterName);
        if (filter == null) {
            throw new IOException("Invalid filter: " + filterName);
        }
        return filter;
    }

    Collection<Filter> getAllFilters() {
        return this.filters.values();
    }
}

