/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.cos;

import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.io.RandomAccess;
import com.tom_roush.pdfbox.io.RandomAccessInputStream;
import com.tom_roush.pdfbox.io.RandomAccessOutputStream;
import com.tom_roush.pdfbox.io.ScratchFile;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public final class COSOutputStream
extends FilterOutputStream {
    private final List<Filter> filters;
    private final COSDictionary parameters;
    private final ScratchFile scratchFile;
    private RandomAccess buffer;

    COSOutputStream(List<Filter> filters, COSDictionary parameters, OutputStream output, ScratchFile scratchFile) throws IOException {
        super(output);
        this.filters = filters;
        this.parameters = parameters;
        this.scratchFile = scratchFile;
        this.buffer = filters.isEmpty() ? null : scratchFile.createBuffer();
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.buffer != null) {
            this.buffer.write(b);
        } else {
            super.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.buffer != null) {
            this.buffer.write(b, off, len);
        } else {
            super.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffer != null) {
            this.buffer.write(b);
        } else {
            super.write(b);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer == null) {
            super.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.buffer == null) return;
            try {
                int i = this.filters.size() - 1;
                while (i >= 0) {
                    block17: {
                        try (RandomAccessInputStream unfilteredIn = new RandomAccessInputStream(this.buffer);){
                            if (i == 0) {
                                this.filters.get(i).encode(unfilteredIn, this.out, this.parameters, i);
                                break block17;
                            }
                            try (RandomAccess filteredBuffer = this.scratchFile.createBuffer();){
                                try (RandomAccessOutputStream filteredOut = new RandomAccessOutputStream(filteredBuffer);){
                                    this.filters.get(i).encode(unfilteredIn, filteredOut, this.parameters, i);
                                }
                                RandomAccess tmpSwap = filteredBuffer;
                                filteredBuffer = this.buffer;
                                this.buffer = tmpSwap;
                            }
                        }
                    }
                    --i;
                }
                return;
            }
            finally {
                this.buffer.close();
                this.buffer = null;
            }
        }
        finally {
            super.close();
        }
    }
}

