/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.harmony.javax.imageio.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public final class RandomAccessMemoryCache {
    private static final int BLOCK_SHIFT = 9;
    private static final int BLOCK_SIZE = 512;
    private static final int BLOCK_MASK = 511;
    private long length;
    private int firstUndisposed = 0;
    private ArrayList<byte[]> blocks = new ArrayList();

    public long length() {
        return this.length;
    }

    public void close() {
        this.blocks.clear();
        this.length = 0L;
    }

    private void grow(long pos) {
        int blocksNeeded = (int)(pos >> 9) - this.blocks.size() + 1;
        for (int i = 0; i < blocksNeeded; ++i) {
            this.blocks.add(new byte[512]);
        }
        this.length = pos + 1L;
    }

    public void putData(int oneByte, long pos) {
        if (pos >= this.length) {
            this.grow(pos);
        }
        byte[] block = this.blocks.get((int)(pos >> 9));
        block[(int)(pos & 0x1FFL)] = (byte)oneByte;
    }

    public void putData(byte[] buffer, int offset, int count, long pos) {
        if (count > buffer.length - offset || count < 0 || offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        long lastPos = pos + (long)count - 1L;
        if (lastPos >= this.length) {
            this.grow(lastPos);
        }
        while (count > 0) {
            byte[] block = this.blocks.get((int)(pos >> 9));
            int blockOffset = (int)(pos & 0x1FFL);
            int toCopy = Math.min(512 - blockOffset, count);
            System.arraycopy(buffer, offset, block, blockOffset, toCopy);
            pos += (long)toCopy;
            count -= toCopy;
            offset += toCopy;
        }
    }

    public int getData(long pos) {
        if (pos >= this.length) {
            return -1;
        }
        byte[] block = this.blocks.get((int)(pos >> 9));
        return block[(int)(pos & 0x1FFL)] & 0xFF;
    }

    public int getData(byte[] buffer, int offset, int count, long pos) {
        if (count > buffer.length - offset || count < 0 || offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return 0;
        }
        if (pos >= this.length) {
            return -1;
        }
        if ((long)count + pos > this.length) {
            count = (int)(this.length - pos);
        }
        byte[] block = this.blocks.get((int)(pos >> 9));
        int nbytes = Math.min(count, 512 - (int)(pos & 0x1FFL));
        System.arraycopy(block, (int)(pos & 0x1FFL), buffer, offset, nbytes);
        return nbytes;
    }

    public void freeBefore(long pos) {
        int blockIdx = (int)(pos >> 9);
        if (blockIdx <= this.firstUndisposed) {
            return;
        }
        for (int i = this.firstUndisposed; i < blockIdx; ++i) {
            this.blocks.set(i, null);
        }
        this.firstUndisposed = blockIdx;
    }

    public int appendData(InputStream is, int count) throws IOException {
        if (count <= 0) {
            return 0;
        }
        long startPos = this.length;
        long lastPos = this.length + (long)count - 1L;
        this.grow(lastPos);
        int blockIdx = (int)(startPos >> 9);
        int offset = (int)(startPos & 0x1FFL);
        int bytesAppended = 0;
        while (count > 0) {
            byte[] block = this.blocks.get(blockIdx);
            int toCopy = Math.min(512 - offset, count);
            count -= toCopy;
            bytesAppended += toCopy;
            while (toCopy > 0) {
                int bytesRead = is.read(block, offset, toCopy);
                if (bytesRead < 0) {
                    this.length -= (long)(count - bytesAppended);
                    return bytesAppended;
                }
                toCopy -= bytesRead;
                offset += bytesRead;
            }
            ++blockIdx;
            offset = 0;
        }
        return bytesAppended;
    }

    public void getData(OutputStream os, int count, long pos) throws IOException {
        if (pos + (long)count > this.length) {
            throw new IndexOutOfBoundsException("Argument out of cache");
        }
        int blockIdx = (int)(pos >> 9);
        int offset = (int)(pos & 0x1FFL);
        if (blockIdx < this.firstUndisposed) {
            throw new IndexOutOfBoundsException("The requested data are already disposed");
        }
        while (count > 0) {
            byte[] block = this.blocks.get(blockIdx);
            int toWrite = Math.min(512 - offset, count);
            os.write(block, offset, toWrite);
            ++blockIdx;
            offset = 0;
            count -= toWrite;
        }
    }
}

