/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.rendering;

import android.graphics.Path;
import android.util.Log;
import com.tom_roush.fontbox.ttf.HeaderTable;
import com.tom_roush.fontbox.ttf.TrueTypeFont;
import com.tom_roush.harmony.awt.geom.AffineTransform;
import com.tom_roush.pdfbox.pdmodel.font.PDCIDFontType2;
import com.tom_roush.pdfbox.pdmodel.font.PDFont;
import com.tom_roush.pdfbox.pdmodel.font.PDTrueTypeFont;
import com.tom_roush.pdfbox.pdmodel.font.PDType0Font;
import com.tom_roush.pdfbox.pdmodel.font.PDVectorFont;
import com.tom_roush.pdfbox.rendering.Glyph2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class TTFGlyph2D
implements Glyph2D {
    private final PDFont font;
    private final TrueTypeFont ttf;
    private PDVectorFont vectorFont;
    private float scale = 1.0f;
    private boolean hasScaling;
    private final Map<Integer, Path> glyphs = new HashMap<Integer, Path>();
    private final boolean isCIDFont;

    TTFGlyph2D(PDTrueTypeFont ttfFont) throws IOException {
        this(ttfFont.getTrueTypeFont(), ttfFont, false);
        this.vectorFont = ttfFont;
    }

    TTFGlyph2D(PDType0Font type0Font) throws IOException {
        this(((PDCIDFontType2)type0Font.getDescendantFont()).getTrueTypeFont(), type0Font, true);
        this.vectorFont = type0Font;
    }

    private TTFGlyph2D(TrueTypeFont ttf, PDFont font, boolean isCIDFont) throws IOException {
        this.font = font;
        this.ttf = ttf;
        this.isCIDFont = isCIDFont;
        HeaderTable header = this.ttf.getHeader();
        if (header != null && header.getUnitsPerEm() != 1000) {
            this.scale = 1000.0f / (float)header.getUnitsPerEm();
            this.hasScaling = true;
        }
    }

    @Override
    public Path getPathForCharacterCode(int code) throws IOException {
        int gid = this.getGIDForCharacterCode(code);
        return this.getPathForGID(gid, code);
    }

    private int getGIDForCharacterCode(int code) throws IOException {
        if (this.isCIDFont) {
            return ((PDType0Font)this.font).codeToGID(code);
        }
        return ((PDTrueTypeFont)this.font).codeToGID(code);
    }

    public Path getPathForGID(int gid, int code) throws IOException {
        if (gid == 0 && !this.isCIDFont && code == 10 && this.font.isStandard14()) {
            Log.w((String)"PdfBox-Android", (String)("No glyph for code " + code + " in font " + this.font.getName()));
            return new Path();
        }
        Path glyphPath = this.glyphs.get(gid);
        if (glyphPath == null) {
            if (gid == 0 || gid >= this.ttf.getMaximumProfile().getNumGlyphs()) {
                if (this.isCIDFont) {
                    int cid = ((PDType0Font)this.font).codeToCID(code);
                    String cidHex = String.format("%04x", cid);
                    Log.w((String)"PdfBox-Android", (String)("No glyph for code " + code + " (CID " + cidHex + ") in font " + this.font.getName()));
                } else {
                    Log.w((String)"PdfBox-Android", (String)("No glyph for " + code + " in font " + this.font.getName()));
                }
            }
            Path glyph = this.vectorFont.getPath(code);
            if (gid == 0 && !this.font.isEmbedded() && !this.font.isStandard14()) {
                glyph = null;
            }
            if (glyph == null) {
                glyphPath = new Path();
            } else {
                glyphPath = glyph;
                if (this.hasScaling) {
                    AffineTransform atScale = AffineTransform.getScaleInstance(this.scale, this.scale);
                    glyphPath.transform(atScale.toMatrix());
                }
            }
        }
        return new Path(glyphPath);
    }

    @Override
    public void dispose() {
        this.glyphs.clear();
    }
}

