/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.Log;
import com.tom_roush.harmony.javax.imageio.stream.MemoryCacheImageInputStream;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSNumber;
import com.tom_roush.pdfbox.filter.DecodeOptions;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.image.PDImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class SampledImageReader {
    private SampledImageReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getStencilImage(PDImage pdImage, Paint paint) throws IOException {
        int width = pdImage.getWidth();
        int height = pdImage.getHeight();
        Bitmap masked = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas g = new Canvas(masked);
        g.drawRect(0.0f, 0.0f, (float)width, (float)height, paint);
        try (MemoryCacheImageInputStream iis = null;){
            iis = new MemoryCacheImageInputStream(pdImage.createInputStream());
            float[] decode = SampledImageReader.getDecodeArray(pdImage);
            int value = decode[0] < decode[1] ? 1 : 0;
            int rowLen = width / 8;
            if (width % 8 > 0) {
                ++rowLen;
            }
            byte[] buff = new byte[rowLen];
            for (int y = 0; y < height; ++y) {
                int x = 0;
                int readLen = iis.read(buff);
                block4: for (int r = 0; r < rowLen && r < readLen; ++r) {
                    byte byteValue = buff[r];
                    int mask = 128;
                    int shift = 7;
                    for (int i = 0; i < 8; ++i) {
                        int bit = (byteValue & mask) >> shift;
                        mask >>= 1;
                        --shift;
                        if (bit == value) {
                            masked.setPixel(x, y, 0);
                        }
                        if (++x == width) continue block4;
                    }
                }
                if (readLen == rowLen) continue;
                Log.w((String)"PdfBox-Android", (String)"premature EOF, image will be incomplete");
                break;
            }
        }
        return masked;
    }

    public static Bitmap getRGBImage(PDImage pdImage, COSArray colorKey) throws IOException {
        return SampledImageReader.getRGBImage(pdImage, null, 1, colorKey);
    }

    private static Rect clipRegion(PDImage pdImage, Rect region) {
        if (region == null) {
            return new Rect(0, 0, pdImage.getWidth(), pdImage.getHeight());
        }
        int x = Math.max(0, region.left);
        int y = Math.max(0, region.top);
        int width = Math.min(region.width(), pdImage.getWidth() - x);
        int height = Math.min(region.height(), pdImage.getHeight() - y);
        return new Rect(x, y, width, height);
    }

    public static Bitmap getRGBImage(PDImage pdImage, Rect region, int subsampling, COSArray colorKey) throws IOException {
        if (pdImage.isEmpty()) {
            throw new IOException("Image stream is empty");
        }
        Rect clipped = SampledImageReader.clipRegion(pdImage, region);
        PDColorSpace colorSpace = pdImage.getColorSpace();
        int numComponents = colorSpace.getNumberOfComponents();
        int width = (int)Math.ceil(clipped.width() / subsampling);
        int height = (int)Math.ceil(clipped.height() / subsampling);
        int bitsPerComponent = pdImage.getBitsPerComponent();
        float[] decode = SampledImageReader.getDecodeArray(pdImage);
        if (width <= 0 || height <= 0 || pdImage.getWidth() <= 0 || pdImage.getHeight() <= 0) {
            throw new IOException("image width and height must be positive");
        }
        if (bitsPerComponent == 1 && colorKey == null && numComponents == 1) {
            return SampledImageReader.from1Bit(pdImage, clipped, subsampling, width, height);
        }
        float[] defaultDecode = pdImage.getColorSpace().getDefaultDecode(8);
        if (pdImage.getSuffix() != null && pdImage.getSuffix().equals("jpg") && subsampling == 1) {
            return BitmapFactory.decodeStream((InputStream)pdImage.createInputStream());
        }
        if (bitsPerComponent == 8 && Arrays.equals(decode, defaultDecode) && colorKey == null) {
            return SampledImageReader.from8bit(pdImage, clipped, subsampling, width, height);
        }
        Log.e((String)"PdfBox-Android", (String)"Trying to create other-bit image not supported");
        return SampledImageReader.from8bit(pdImage, clipped, subsampling, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap from1Bit(PDImage pdImage, Rect clipped, int subsampling, int width, int height) throws IOException {
        int currentSubsampling = subsampling;
        PDColorSpace colorSpace = pdImage.getColorSpace();
        float[] decode = SampledImageReader.getDecodeArray(pdImage);
        Bitmap raster = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ALPHA_8);
        ByteBuffer buffer = ByteBuffer.allocate(raster.getRowBytes() * height);
        raster.copyPixelsToBuffer((Buffer)buffer);
        DecodeOptions options = new DecodeOptions(currentSubsampling);
        options.setSourceRegion(clipped);
        try (InputStream iis = null;){
            int value1;
            int value0;
            int scanHeight;
            int scanWidth;
            int starty;
            int startx;
            int inputWidth;
            if (options.isFilterSubsampled()) {
                inputWidth = width;
                startx = 0;
                starty = 0;
                scanWidth = width;
                scanHeight = height;
                currentSubsampling = 1;
            } else {
                inputWidth = pdImage.getWidth();
                startx = clipped.left;
                starty = clipped.top;
                scanWidth = clipped.width();
                scanHeight = clipped.height();
            }
            byte[] output = buffer.array();
            boolean isIndexed = false;
            iis = pdImage.createInputStream(options);
            int rowLen = inputWidth / 8;
            if (inputWidth % 8 > 0) {
                ++rowLen;
            }
            if (decode[0] < decode[1]) {
                value0 = 0;
                value1 = -1;
            } else {
                value0 = -1;
                value1 = 0;
            }
            byte[] buff = new byte[rowLen];
            int idx = 0;
            for (int y = 0; y < starty + scanHeight; ++y) {
                int x = 0;
                int readLen = iis.read(buff);
                if (y < starty || y % currentSubsampling > 0) continue;
                for (int r = 0; r < rowLen && r < readLen; ++r) {
                    byte value = buff[r];
                    int mask = 128;
                    for (int i = 0; i < 8 && x < startx + scanWidth; ++x, ++i) {
                        int bit = value & mask;
                        mask >>= 1;
                        if (x < startx || x % currentSubsampling != 0) continue;
                        output[idx++] = bit == 0 ? value0 : value1;
                    }
                }
                if (readLen == rowLen) continue;
                Log.w((String)"PdfBox-Android", (String)"premature EOF, image will be incomplete");
                break;
            }
            buffer.rewind();
            raster.copyPixelsFromBuffer((Buffer)buffer);
            Bitmap bitmap = colorSpace.toRGBImage(raster);
            return bitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap from8bit(PDImage pdImage, Rect clipped, int subsampling, int width, int height) throws IOException {
        int currentSubsampling = subsampling;
        DecodeOptions options = new DecodeOptions(currentSubsampling);
        options.setSourceRegion(clipped);
        InputStream input = pdImage.createInputStream(options);
        try {
            int scanHeight;
            int scanWidth;
            int starty;
            int startx;
            int inputWidth;
            if (options.isFilterSubsampled()) {
                inputWidth = width;
                startx = 0;
                starty = 0;
                scanWidth = width;
                scanHeight = height;
                currentSubsampling = 1;
            } else {
                inputWidth = pdImage.getWidth();
                startx = clipped.left;
                starty = clipped.top;
                scanWidth = clipped.width();
                scanHeight = clipped.height();
            }
            int numComponents = pdImage.getColorSpace().getNumberOfComponents();
            int[] banks = new int[width * height];
            byte[] tempBytes = new byte[numComponents * inputWidth];
            int i = 0;
            for (int y = 0; y < starty + scanHeight; ++y) {
                input.read(tempBytes);
                if (y < starty || y % currentSubsampling > 0) continue;
                for (int x = startx; x < startx + scanWidth; x += currentSubsampling) {
                    int tempBytesIdx = x * numComponents;
                    if (numComponents == 3) {
                        banks[i] = Color.argb((int)255, (int)(tempBytes[tempBytesIdx] & 0xFF), (int)(tempBytes[tempBytesIdx + 1] & 0xFF), (int)(tempBytes[tempBytesIdx + 2] & 0xFF));
                    } else if (numComponents == 1) {
                        int in = tempBytes[tempBytesIdx] & 0xFF;
                        banks[i] = Color.argb((int)in, (int)in, (int)in, (int)in);
                    }
                    ++i;
                }
            }
            Bitmap raster = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            raster.setPixels(banks, 0, width, 0, 0, width, height);
            Bitmap bitmap = raster;
            return bitmap;
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    private static float[] getDecodeArray(PDImage pdImage) throws IOException {
        COSArray cosDecode = pdImage.getDecode();
        float[] decode = null;
        if (cosDecode != null) {
            int numberOfComponents = pdImage.getColorSpace().getNumberOfComponents();
            if (cosDecode.size() != numberOfComponents * 2) {
                if (pdImage.isStencil() && cosDecode.size() >= 2 && cosDecode.get(0) instanceof COSNumber && cosDecode.get(1) instanceof COSNumber) {
                    float decode0 = ((COSNumber)cosDecode.get(0)).floatValue();
                    float decode1 = ((COSNumber)cosDecode.get(1)).floatValue();
                    if (decode0 >= 0.0f && decode0 <= 1.0f && decode1 >= 0.0f && decode1 <= 1.0f) {
                        Log.w((String)"PdfBox-Android", (String)("decode array " + cosDecode + " not compatible with color space, using the first two entries"));
                        return new float[]{decode0, decode1};
                    }
                }
                Log.e((String)"PdfBox-Android", (String)("decode array " + cosDecode + " not compatible with color space, using default"));
            } else {
                decode = cosDecode.toFloatArray();
            }
        }
        if (decode == null) {
            return pdImage.getColorSpace().getDefaultDecode(pdImage.getBitsPerComponent());
        }
        return decode;
    }
}

