/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdfparser;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSDocument;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.io.RandomAccessRead;
import com.tom_roush.pdfbox.io.ScratchFile;
import com.tom_roush.pdfbox.pdfparser.COSParser;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.encryption.InvalidPasswordException;
import java.io.IOException;
import java.io.InputStream;

public class PDFParser
extends COSParser {
    public PDFParser(RandomAccessRead source) throws IOException {
        this(source, "", ScratchFile.getMainMemoryOnlyInstance());
    }

    public PDFParser(RandomAccessRead source, ScratchFile scratchFile) throws IOException {
        this(source, "", scratchFile);
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword) throws IOException {
        this(source, decryptionPassword, ScratchFile.getMainMemoryOnlyInstance());
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword, ScratchFile scratchFile) throws IOException {
        this(source, decryptionPassword, null, null, scratchFile);
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword, InputStream keyStore, String alias) throws IOException {
        this(source, decryptionPassword, keyStore, alias, ScratchFile.getMainMemoryOnlyInstance());
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword, InputStream keyStore, String alias, ScratchFile scratchFile) throws IOException {
        super(source, decryptionPassword, keyStore, alias);
        this.fileLen = source.length();
        this.init(scratchFile);
    }

    private void init(ScratchFile scratchFile) throws IOException {
        String eofLookupRangeStr = System.getProperty("com.tom_roush.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange");
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException nfe) {
                Log.w((String)"PdfBox-Android", (String)("System property com.tom_roush.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange does not contain an integer value, but: '" + eofLookupRangeStr + "'"));
            }
        }
        this.document = new COSDocument(scratchFile);
    }

    public PDDocument getPDDocument() throws IOException {
        PDDocument doc = new PDDocument(this.getDocument(), this.source, this.getAccessPermission());
        doc.setEncryptionDictionary(this.getEncryption());
        return doc;
    }

    protected void initialParse() throws InvalidPasswordException, IOException {
        COSDictionary trailer = this.retrieveTrailer();
        COSBase base = this.parseTrailerValuesDynamically(trailer);
        if (!(base instanceof COSDictionary)) {
            throw new IOException("Expected root dictionary, but got this: " + base);
        }
        COSDictionary root = (COSDictionary)base;
        if (this.isLenient() && !root.containsKey(COSName.TYPE)) {
            root.setItem(COSName.TYPE, (COSBase)COSName.CATALOG);
        }
        this.parseDictObjects(root, null);
        COSBase infoBase = trailer.getDictionaryObject(COSName.INFO);
        if (infoBase instanceof COSDictionary) {
            this.parseDictObjects((COSDictionary)infoBase, null);
        }
        this.checkPages(root);
        if (!(root.getDictionaryObject(COSName.PAGES) instanceof COSDictionary)) {
            throw new IOException("Page tree root must be a dictionary");
        }
        this.document.setDecrypted();
        this.initialParseDone = true;
    }

    public void parse() throws InvalidPasswordException, IOException {
        boolean exceptionOccurred = true;
        try {
            if (!this.parsePDFHeader() && !this.parseFDFHeader()) {
                throw new IOException("Error: Header doesn't contain versioninfo");
            }
            if (!this.initialParseDone) {
                this.initialParse();
            }
            exceptionOccurred = false;
        }
        finally {
            if (exceptionOccurred && this.document != null) {
                IOUtils.closeQuietly(this.document);
                this.document = null;
            }
        }
    }
}

