/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.multipdf;

import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.PDPage;
import java.io.IOException;

public class PageExtractor {
    private PDDocument sourceDocument;
    private int startPage = 1;
    private int endPage = 0;

    public PageExtractor(PDDocument sourceDocument) {
        this.sourceDocument = sourceDocument;
        this.endPage = sourceDocument.getNumberOfPages();
    }

    public PageExtractor(PDDocument sourceDocument, int startPage, int endPage) {
        this(sourceDocument);
        this.startPage = startPage;
        this.endPage = endPage;
    }

    public PDDocument extract() throws IOException {
        PDDocument extractedDocument = new PDDocument();
        extractedDocument.setDocumentInformation(this.sourceDocument.getDocumentInformation());
        extractedDocument.getDocumentCatalog().setViewerPreferences(this.sourceDocument.getDocumentCatalog().getViewerPreferences());
        for (int i = this.startPage; i <= this.endPage; ++i) {
            PDPage page = this.sourceDocument.getPage(i - 1);
            PDPage imported = extractedDocument.importPage(page);
            imported.setCropBox(page.getCropBox());
            imported.setMediaBox(page.getMediaBox());
            imported.setResources(page.getResources());
            imported.setRotation(page.getRotation());
        }
        return extractedDocument;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }
}

