/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.rendering;

import android.graphics.Path;
import android.util.Log;
import com.tom_roush.pdfbox.pdmodel.font.PDCIDFontType0;
import com.tom_roush.pdfbox.rendering.Glyph2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class CIDType0Glyph2D
implements Glyph2D {
    private final Map<Integer, Path> cache = new HashMap<Integer, Path>();
    private final PDCIDFontType0 font;
    private final String fontName;

    CIDType0Glyph2D(PDCIDFontType0 font) {
        this.font = font;
        this.fontName = font.getBaseFont();
    }

    @Override
    public Path getPathForCharacterCode(int code) {
        if (this.cache.containsKey(code)) {
            return this.cache.get(code);
        }
        try {
            if (!this.font.hasGlyph(code)) {
                int cid = this.font.getParent().codeToCID(code);
                String cidHex = String.format("%04x", cid);
                Log.w((String)"PdfBox-Android", (String)("No glyph for " + code + " (CID " + cidHex + ") in font " + this.fontName));
            }
            Path path = this.font.getPath(code);
            this.cache.put(code, path);
            return path;
        }
        catch (IOException e) {
            Log.w((String)"PdfBox-Android", (String)"Glyph rendering failed", (Throwable)e);
            return new Path();
        }
    }

    @Override
    public void dispose() {
        this.cache.clear();
    }
}

