/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.form;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PDXFA
implements COSObjectable {
    private COSBase xfa;

    public PDXFA(COSBase xfaBase) {
        this.xfa = xfaBase;
    }

    @Override
    public COSBase getCOSObject() {
        return this.xfa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = null;
        byte[] xfaBytes = null;
        try {
            if (this.getCOSObject() instanceof COSArray) {
                xfaBytes = new byte[1024];
                COSArray cosArray = (COSArray)this.getCOSObject();
                for (int i = 1; i < cosArray.size(); i += 2) {
                    COSBase cosObj = cosArray.getObject(i);
                    if (!(cosObj instanceof COSStream)) continue;
                    is = ((COSStream)cosObj).createInputStream();
                    int nRead = 0;
                    while ((nRead = is.read(xfaBytes, 0, xfaBytes.length)) != -1) {
                        baos.write(xfaBytes, 0, nRead);
                    }
                    baos.flush();
                }
            } else if (this.xfa.getCOSObject() instanceof COSStream) {
                xfaBytes = new byte[1024];
                is = ((COSStream)this.xfa.getCOSObject()).createInputStream();
                int nRead = 0;
                while ((nRead = is.read(xfaBytes, 0, xfaBytes.length)) != -1) {
                    baos.write(xfaBytes, 0, nRead);
                }
                baos.flush();
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return baos.toByteArray();
    }

    public Document getDocument() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xfaDocument = builder.parse(new ByteArrayInputStream(this.getBytes()));
        return xfaDocument;
    }
}

