/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.form;

import com.tom_roush.pdfbox.contentstream.operator.Operator;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSNumber;
import com.tom_roush.pdfbox.cos.COSString;
import com.tom_roush.pdfbox.pdfparser.PDFStreamParser;
import com.tom_roush.pdfbox.pdmodel.PDPageContentStream;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.font.PDFont;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import java.io.IOException;
import java.util.List;

class PDDefaultAppearanceString {
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    private final List<Object> tokens;
    private final PDResources defaultResources;

    PDDefaultAppearanceString(COSString defaultAppearance, PDResources defaultResources) throws IOException {
        if (defaultAppearance == null) {
            throw new IllegalArgumentException("/DA is a required entry");
        }
        if (defaultResources == null) {
            throw new IllegalArgumentException("/DR is a required entry");
        }
        PDFStreamParser parser = new PDFStreamParser(defaultAppearance.getBytes());
        parser.parse();
        this.tokens = parser.getTokens();
        this.defaultResources = defaultResources;
    }

    public float getFontSize() {
        int fontIndex;
        if (!this.tokens.isEmpty() && (fontIndex = this.tokens.indexOf(Operator.getOperator("Tf"))) != -1) {
            return ((COSNumber)this.tokens.get(fontIndex - 1)).floatValue();
        }
        return 12.0f;
    }

    public float getLineWidth() {
        float retval = 0.0f;
        if (this.tokens != null) {
            int btIndex = this.tokens.indexOf(Operator.getOperator("BT"));
            int wIndex = this.tokens.indexOf(Operator.getOperator("w"));
            if (wIndex > 0 && (wIndex < btIndex || btIndex == -1)) {
                retval = ((COSNumber)this.tokens.get(wIndex - 1)).floatValue();
            }
        }
        return retval;
    }

    public PDFont getFont() throws IOException {
        COSName name = this.getFontResourceName();
        PDFont font = this.defaultResources.getFont(name);
        if (font == null) {
            throw new IOException("Could not find font: /" + name.getName());
        }
        return font;
    }

    private COSName getFontResourceName() {
        int setFontOperatorIndex = this.tokens.indexOf(Operator.getOperator("Tf"));
        return (COSName)this.tokens.get(setFontOperatorIndex - 2);
    }

    void writeTo(PDPageContentStream contents, float zeroFontSize) throws IOException {
        float fontSize = this.getFontSize();
        if (fontSize == 0.0f) {
            fontSize = zeroFontSize;
        }
        contents.setFont(this.getFont(), fontSize);
    }

    void copyNeededResourcesTo(PDAppearanceStream appearanceStream) throws IOException {
        COSName fontName;
        PDResources streamResources = appearanceStream.getResources();
        if (streamResources == null) {
            streamResources = new PDResources();
            appearanceStream.setResources(streamResources);
        }
        if (streamResources.getFont(fontName = this.getFontResourceName()) == null) {
            streamResources.put(fontName, this.getFont());
        }
    }
}

