/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.form;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSString;
import com.tom_roush.pdfbox.pdmodel.common.COSArrayList;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDAcroForm;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDTerminalField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PDButton
extends PDTerminalField {
    static final int FLAG_RADIO = 32768;
    static final int FLAG_PUSHBUTTON = 65536;
    static final int FLAG_RADIOS_IN_UNISON = 0x2000000;

    public PDButton(PDAcroForm acroForm) {
        super(acroForm);
        this.dictionary.setItem(COSName.FT, (COSBase)COSName.BTN);
    }

    PDButton(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    public boolean isPushButton() {
        return this.dictionary.getFlag(COSName.FF, 65536);
    }

    public void setPushButton(boolean pushbutton) {
        this.dictionary.setFlag(COSName.FF, 65536, pushbutton);
    }

    public boolean isRadioButton() {
        return this.dictionary.getFlag(COSName.FF, 32768);
    }

    public void setRadioButton(boolean radiobutton) {
        this.dictionary.setFlag(COSName.FF, 32768, radiobutton);
    }

    public List<String> getExportValues() {
        COSBase value = this.getInheritableAttribute(COSName.OPT);
        if (value instanceof COSString) {
            ArrayList<String> array = new ArrayList<String>();
            array.add(((COSString)value).getString());
            return array;
        }
        if (value instanceof COSArray) {
            return COSArrayList.convertCOSStringCOSArrayToList((COSArray)value);
        }
        return Collections.emptyList();
    }

    public void setExportValues(List<String> values) {
        if (values != null && !values.isEmpty()) {
            COSArray cosValues = COSArrayList.convertStringListToCOSStringCOSArray(values);
            this.dictionary.setItem(COSName.OPT, (COSBase)cosValues);
        } else {
            this.dictionary.removeItem(COSName.OPT);
        }
    }

    @Override
    void constructAppearances() throws IOException {
        for (PDAnnotationWidget widget : this.getWidgets()) {
            PDAppearanceDictionary appearance = widget.getAppearance();
            if (appearance != null && appearance.getNormalAppearance() != null) continue;
            throw new UnsupportedOperationException("Appearance generation is not implemented yet, see PDFBOX-2849");
        }
    }
}

