/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.form;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSString;
import com.tom_roush.pdfbox.pdmodel.common.COSArrayList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class FieldUtils {
    private FieldUtils() {
    }

    static List<KeyValue> toKeyValueList(List<String> key, List<String> value) {
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        for (int i = 0; i < key.size(); ++i) {
            list.add(new KeyValue(key.get(i), value.get(i)));
        }
        return list;
    }

    static void sortByValue(List<KeyValue> pairs) {
        Collections.sort(pairs, new KeyValueValueComparator());
    }

    static void sortByKey(List<KeyValue> pairs) {
        Collections.sort(pairs, new KeyValueKeyComparator());
    }

    static List<String> getPairableItems(COSBase items, int pairIdx) {
        if (pairIdx < 0 || pairIdx > 1) {
            throw new IllegalArgumentException("Only 0 and 1 are allowed as an index into two-element arrays");
        }
        if (items instanceof COSString) {
            ArrayList<String> array = new ArrayList<String>();
            array.add(((COSString)items).getString());
            return array;
        }
        if (items instanceof COSArray) {
            COSBase entry = ((COSArray)items).get(0);
            if (entry instanceof COSString) {
                return COSArrayList.convertCOSStringCOSArrayToList((COSArray)items);
            }
            return FieldUtils.getItemsFromPair(items, pairIdx);
        }
        return Collections.emptyList();
    }

    private static List<String> getItemsFromPair(COSBase items, int pairIdx) {
        ArrayList<String> exportValues = new ArrayList<String>();
        int numItems = ((COSArray)items).size();
        for (int i = 0; i < numItems; ++i) {
            COSArray pair = (COSArray)((COSArray)items).get(i);
            COSString displayValue = (COSString)pair.get(pairIdx);
            exportValues.add(displayValue.getString());
        }
        return exportValues;
    }

    static class KeyValueValueComparator
    implements Serializable,
    Comparator<KeyValue> {
        private static final long serialVersionUID = -3984095679894798265L;

        KeyValueValueComparator() {
        }

        @Override
        public int compare(KeyValue o1, KeyValue o2) {
            return o1.value.compareTo(o2.value);
        }
    }

    static class KeyValueKeyComparator
    implements Serializable,
    Comparator<KeyValue> {
        private static final long serialVersionUID = 6715364290007167694L;

        KeyValueKeyComparator() {
        }

        @Override
        public int compare(KeyValue o1, KeyValue o2) {
            return o1.key.compareTo(o2.key);
        }
    }

    static class KeyValue {
        private final String key;
        private final String value;

        KeyValue(String theKey, String theValue) {
            this.key = theKey;
            this.value = theValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "(" + this.key + ", " + this.value + ")";
        }
    }
}

