/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.pattern;

import com.tom_roush.harmony.awt.geom.AffineTransform;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSFloat;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.graphics.pattern.PDShadingPattern;
import com.tom_roush.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import com.tom_roush.pdfbox.util.Matrix;
import java.io.IOException;

public abstract class PDAbstractPattern
implements COSObjectable {
    public static final int TYPE_TILING_PATTERN = 1;
    public static final int TYPE_SHADING_PATTERN = 2;
    private final COSDictionary patternDictionary;

    public static PDAbstractPattern create(COSDictionary resourceDictionary) throws IOException {
        PDAbstractPattern pattern;
        int patternType = resourceDictionary.getInt(COSName.PATTERN_TYPE, 0);
        switch (patternType) {
            case 1: {
                pattern = new PDTilingPattern(resourceDictionary);
                break;
            }
            case 2: {
                pattern = new PDShadingPattern(resourceDictionary);
                break;
            }
            default: {
                throw new IOException("Error: Unknown pattern type " + patternType);
            }
        }
        return pattern;
    }

    public PDAbstractPattern() {
        this.patternDictionary = new COSDictionary();
        this.patternDictionary.setName(COSName.TYPE, COSName.PATTERN.getName());
    }

    public PDAbstractPattern(COSDictionary resourceDictionary) {
        this.patternDictionary = resourceDictionary;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.patternDictionary;
    }

    public void setPaintType(int paintType) {
        this.patternDictionary.setInt(COSName.PAINT_TYPE, paintType);
    }

    public String getType() {
        return COSName.PATTERN.getName();
    }

    public void setPatternType(int patternType) {
        this.patternDictionary.setInt(COSName.PATTERN_TYPE, patternType);
    }

    public abstract int getPatternType();

    public Matrix getMatrix() {
        COSArray array = (COSArray)this.getCOSObject().getDictionaryObject(COSName.MATRIX);
        if (array != null) {
            return new Matrix(array);
        }
        return new Matrix();
    }

    public void setMatrix(AffineTransform transform) {
        COSArray matrix = new COSArray();
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            matrix.add(new COSFloat((float)v));
        }
        this.getCOSObject().setItem(COSName.MATRIX, (COSBase)matrix);
    }
}

